/* --- Copyright University of Sussex 1994. All rights reserved. ----------
 > File:            $popvision/lib/solve_dilation.p
 > Purpose:         Least-squares estimate dilating flow-field parameters
 > Author:          David S Young, Apr 11 1994
 > Documentation:   HELP * SOLVE_DILATION
 */

compile_mode:pop11 +strict;

section;

define solve_dilation(U, V) -> (D, x0, y0);
    lvars U, V, D, x0, y0;
    ;;; Returns least-squares estimates of the flow parameters, assuming
    ;;; a simple dilational flow-field. D is dilation, x0 and y0 FoE
    lvars
        (x0, x1, y0, y1) = explode(boundslist(U)),
        xc = (x0 + x1) / 2,
        yc = (y0 + y1) / 2,
        x, y, u, v, xy, N = 0,
        sx = 0, sy = 0, sxx = 0, syy = 0, su = 0, sv = 0, sxu = 0, syv = 0;
    for u, v with_index xy in_array U, V do
        explode(xy) -> (x, y);
        x - xc -> x;        ;;; centre coords for better numerical stability
        y - yc -> y;
        sx + x      -> sx;              sy + y      -> sy;
        sxx + x*x   -> sxx;             syy + y*y   -> syy;
        su + u      -> su;              sv + v      -> sv;
        sxu + x*u   -> sxu;             syv + y*v   -> syv;
        N + 1 -> N;
    endfor;
    ((su*sx + sv*sy)/N - sxu - syv) / ((sx*sx +sy*sy)/N - sxx - syy) -> D;
    (sx - su/D)/N + xc -> x0;
    (sy - sv/D)/N + yc -> y0
enddefine;

endsection;
