/* --- Copyright University of Sussex 1991.  All Rights Reserved. ---------
 > File:            C.all/x/ui/lib/button_data.p
 > Version :        1.11
 > Purpose:         data for the ISL POPLOG DEMO SYSTEM buttons
 > Author:          J.D.POSTOYKO, May 1991
 > Documentation:
 > Related Files:
*/

compile_mode :pop11 +strict;

section $-demotool;

define set_ss_button();

    consbutton(
       	'Slides',
        false,
        CMD,
        SLIDE_SHOW,
        true,
        252,
        CMD_BUTTON_VERTICAL,
        1,
        'Slide Show', '', '',
        OUT,
		false,
        button_dispatch, SLIDE_SHOW,
        false ) -> button_table("slide_show");

enddefine;


define set_intro_tool_buttons();
    consbutton(
       	'next',
        false,
        CMD,
        NEXT_PAGE,
        true,
        502,
        75,
        1,
        'Next Page', '', '',
        OUT,
		true,
        button_dispatch, NEXT_PAGE,
        false) -> button_table("intro_next");

    consbutton(
       	'previous',
        false,
        CMD,
        PREVIOUS_PAGE,
        true,
        502,
        108,
        1,
        'Previous', 'Page', '',
        OUT,
		false,
        button_dispatch,PREVIOUS_PAGE ,
        false) -> button_table("intro_previous");
/*
    consbutton(
       	'Contents',
        false,
        CMD,
        CONTENTS_PAGE,
        true,
        502,
        141,
        1,
        'Contents', 'Page', '',
        OUT,
		false,
        button_dispatch,CONTENTS_PAGE ,
        false) -> button_table("intro_contents");
	*/
    consbutton(
       	'Save',
        false,
        CMD,
        SAVE_PAGE,
        true,
        502,
        141,;;;174
        1,
        'Save Page', '', '',
        OUT,
		true,
        button_dispatch, SAVE_PAGE,
        false) -> button_table("intro_save");

    consbutton(
       	'restore',
        false,
        CMD,
        RESTORE_PAGE,
        true,
        502,
        174,;;;207
        1,
        'Restore', 'Page', '',
        OUT,
		false,
        button_dispatch,RESTORE_PAGE ,
        false) -> button_table("intro_restore");


    [
        demo_info
        demo_up
		demo_exit
       	intro_next
       	intro_previous
     	intro_save
     	intro_restore
    ]->level_intro_buttons;

enddefine;


vars L1Y1 = 50,L1Y2 = 200;
vars level_menu_bar_buttons;
;;; initial demosystem buttons

define set_level_one_buttons();

    consbutton(
        'Intro to POPLOG',
        false,
        CHUNKY,
        POPLOG_INTRO,
        true,
        100,;;;140
        L1Y1,
        1,
        'Introduction', '        To', '  POPLOG',
        OUT,
		true,
        display, level_intro_index_buttons,
        false ) -> button_table("intro_demo");

    consbutton( 'POPLOG based prods',
        false,
        CHUNKY,
        POPLOG_PRODUCTS,
        true,
        100,;;;140
        L1Y2,
        1,
        '  POPLOG', '     Based', '   Products',
        OUT,
		true,
        display , level_four_buttons ,
        false) -> button_table("pbp_demo");

    consbutton( 'POPLOG libs',
        false,
        CHUNKY,
        POPLOG_LIBS,
        true,
        406,;;;376
        L1Y1,
        1,
        '  POPLOG', '    Source', '  Libraries',
        OUT,
		true,
        display, level_six_buttons,
        false) -> button_table("psl_demo");

    consbutton( 'End user apps',
        false,
        CHUNKY,
        APPLICATION_DEMOS,
        true,
        406,;;; 376
        L1Y2,
        1,
        ' POPLOG', 'Applications', '    Demos',
        OUT,
		true,
        display , level_two_buttons ,
        false) -> button_table("eua_demo");


    consbutton( '? ',
        false,
        CHUNKY,
        DEMOTOOL_TUTORIAL,
        true,
        248,
        125,;;;41,
        1,
        'usesHelpButton', 'demonstration', 'system... ',
        OUT,
		true,
        tutorial1,DEMOTOOL_TUTORIAL,
        'default.desc' ) -> button_table("what_intro");


    consbutton(
       	'info',
        false,
        CMD,
       	INFORMATION,
        false,
        1,
        1,
        1,
        'Information', '', '',
        OUT,
		true,
        button_dispatch, INFORMATION,
        false ) -> button_table("demo_info");

    consbutton(
       	'up',
        false,
        CMD,
       	PREVIOUS_LEVEL,
        false,
        72,
        1,
        1,
        'Previous', 'Level ', '',
        OUT,
		true,
        button_dispatch,PREVIOUS_LEVEL ,
        false ) -> button_table("demo_up");

    consbutton(
       	'exit',
        false,
        CMD,
       	EXIT_DEMOTOOL,
        false,
        504,
        1,
        1,
        'Exit from', 'Demotool', '',
        OUT,
		true,
        button_dispatch,EXIT_DEMOTOOL ,
        false ) -> button_table("demo_exit");



    [
       	demo_info
        demo_up
	demo_exit
	intro_demo
        psl_demo
        eua_demo
        pbp_demo
        what_intro
 	]->level_one_buttons;

    [
       	;;;demo_info
        ;;;demo_up
	;;;demo_exit
 	]->level_menu_bar_buttons;
enddefine;


vars L2Y1 = 50,L2Y2 = 180;

define set_level_two_buttons();

    consbutton( 'EXCAP demo',
        false,
        CHUNKY,
        EXCAP_DEMO,
        false,
        60,
        L2Y1,
        1,
        '', '    EXCAP', '',
        OUT,
		true,
        give_demo_summary, EXCAP_DEMO,
        'excap.desc' ) -> button_table("excap_demo");

    consbutton( '  FAUST demo',
        false,
        CHUNKY,
        FAUST_DEMO,
        false,
        188,
        L2Y1,
        1,
        '', '    FAUST', '',
        OUT,
		true,
        give_demo_summary, FAUST_DEMO ,
        'faust.desc') -> button_table("faust_demo");

    consbutton( 'ARBS demo',
        false,
        CHUNKY,
        ARBS_DEMO,
        false,
        316,
        L2Y1,
        1,
        '', '     ARBS', '',
        OUT,
		true,
        give_demo_summary,ARBS_DEMO ,
        'arbs.desc' ) -> button_table("arbs_demo");

    consbutton( 'tasker demo',
        false,
        CHUNKY,
        TASKER_DEMO,
        false,
        60,
        L2Y2,
        1,
        '', '  TASKER', '',
        OUT,
		true,
        give_demo_summary, TASKER_DEMO ,
        'tasker.desc') -> button_table("tasker_demo");

    consbutton( 'ive',
        false,
        CHUNKY,
        IVE_DEMO,
        false,
        188,
        L2Y2,
        1,
        ' Interactive', '    Vision', 'Environment',
        OUT,
		true,
        give_demo_summary,IVE_DEMO ,
        'ive.desc' ) -> button_table("ive_demo");

    consbutton( 'Med head demo',
        false,
        CHUNKY,
        HEAD_DEMO,
        false,
        316,
        L2Y2,
        1,
        '   Medical', '   Images', '',
        OUT,
		true,
        give_demo_summary, HEAD_DEMO,
        'head.desc' ) -> button_table("head_demo");

    consbutton( 'sat images',
        false,
        CHUNKY,
        KBS_DEMO,
        false,
        444,
        L2Y1,
        1,
        ' Knowledge', '    Based', 'Segmentation',
        OUT,
		true,
        give_demo_summary,KBS_DEMO ,
        'images.desc' ) -> button_table("sat_demo");

    consbutton( 'walker demo',
        false,
        CHUNKY,
        WALKER_DEMO,
        false,
        444,
        L2Y2,
        1,
        '      The', '    Walking', '      Man',
        OUT,
		true,
        give_demo_summary,WALKER_DEMO ,
        'walker.desc' ) -> button_table("walker_demo");

    [
		excap_demo
        faust_demo
        arbs_demo
        tasker_demo
        ive_demo
      	head_demo
		sat_demo
		walker_demo
        demo_info
        demo_up
		demo_exit
   		slide_show
    ]->level_two_buttons;

enddefine;

;;; end user applications demos
define set_level_six_buttons();

    consbutton( ' X demo',
        false,
        CHUNKY,
        X_DEMO,
        true,
        120,
        150,
        1,
        '', '   Xdemo', '',
        OUT,
		true,
        button_dispatch,X_DEMO ,
        'default.desc' ) -> button_table("x_demo");

    consbutton( ' Ms blocks demo',
        false,
        CHUNKY,
        BLOCKS_DEMO,
        true,
        248,
        150,
        1,
        '', '  MS Blocks', '',
        OUT,
		true,
        button_dispatch, BLOCKS_DEMO ,
        'default.desc') -> button_table("blocks_demo");

    consbutton( ' eliza demo',
        false,
        CHUNKY,
        ELIZA_DEMO,
        true,
        376,
        150,
        1,
        '', '   Eliza', '',
        OUT,
		true,
        button_dispatch,ELIZA_DEMO ,
        'default.desc' ) -> button_table("eliza_demo");


    [        demo_info
        demo_up
		demo_exit
    	x_demo blocks_demo eliza_demo
    ]->level_six_buttons;


enddefine;


vars L4Y1 = 120;
;;; poplog based products buttons
define set_level_four_buttons();

    consbutton( 'POPLOG FLEX',
        false,
        CHUNKY,
        FLEX_DEMO,
        true,
        120,
        L4Y1,
        1,
        '   POPLOG', '     FLEX', '\(169) 1991 ISL',
        OUT,
		true,
        button_dispatch,FLEX_DEMO ,
        about_flex ) -> button_table("flex_demo");

    consbutton( 'POPLOG NEURAL',
        false,
        CHUNKY,
        NEURAL_DEMO,
        true,
        248,
		L4Y1,
        1,
        '   POPLOG', '   NEURAL', '\(169) 1991 ISL',
        OUT,
		true,
        button_dispatch,NEURAL_DEMO ,
        about_neural ) -> button_table("neural_demo");

    consbutton( 'POPLOG RULES',
        false,
        CHUNKY,
        RULES_DEMO,
        true,
        376,
		L4Y1,
        1,
        '   POPLOG', '    RULES', '\(169) 1991 ISL',
        OUT,
		true,
        button_dispatch,RULES_DEMO ,
        about_rules) -> button_table("rules_demo");

    [
        flex_demo
        neural_demo
        rules_demo
        demo_info
        demo_up
		demo_exit
	] ->level_four_buttons;

enddefine;



define set_level_intro_buttons();

    consbutton( 'X',
        false,
        CHUNKY,
        ABOUT_X,
        true,
        244,;;;194,
        41,
        1,
        '  ', '          X', ' ',
        OUT,
		true,
        button_dispatch,ABOUT_X ,
        about_xwindows) -> button_table("x_intro");

    consbutton( 'mlp ',
        false,
        CHUNKY,
        ABOUT_MIXED_LANGUAGE_PROGRAMMING,
        true,
        196,;;;146,
        121,
        1,
        '      Mixed', '  Language', 'Programming',
        OUT,
		true,
        button_dispatch,ABOUT_MIXED_LANGUAGE_PROGRAMMING ,
        about_mlp ) -> button_table("mlp_intro");

    consbutton( 'uel ',
        false,
        CHUNKY,
        ABOUT_EXTERNAL_LANGUAGES,
        true,
        284,;;;234,
        121,
        1,
        '     Using', '   External ', '  Languages',
        OUT,
		true,
        button_dispatch,ABOUT_EXTERNAL_LANGUAGES ,
        about_external ) -> button_table("uel_intro");

    consbutton( 'ved ',
        false,
        CHUNKY,
        ABOUT_VED,
        true,
        108,;;;58,
        201,
        1,
        '   ', '      VED ', '     Editor',
        OUT,
		true,
        button_dispatch,ABOUT_VED ,
        about_ved ) -> button_table("ved_intro");

    consbutton( 'im ',
        false,
        CHUNKY,
        ABOUT_INC_COMPILATION,
        true,
        196,;;;146,
        201,
        1,
        ' ','Incremental', 'Compilation',
        OUT,
		true,
        button_dispatch,ABOUT_INC_COMPILATION  ,
        about_inccomp ) -> button_table("im_intro");

    consbutton( ' on line help',
        false,
        CHUNKY,
        ABOUT_ONLINE_HELP,
        true,
        284,;;;234,
        201,
        1,
        ' ','   On-line', '     Help',
        OUT,
		true,
        button_dispatch,ABOUT_ONLINE_HELP ,
        about_help) -> button_table("olh_intro");

    consbutton( ' source libraries',
        false,
        CHUNKY,
        ABOUT_SOURCE_LIBRARIES,
        true,
        372,;;;322,
        201,
        1,
        ' ','    Source', '  Libraries',
        OUT,
		true,
        button_dispatch,ABOUT_SOURCE_LIBRARIES ,
        about_libraries ) -> button_table("sl_intro");

    consbutton( ' pop11',
        false,
        CHUNKY,
        ABOUT_POP11,
        true,
        68,;;;18,
        281,
        1,
        ' ', '   POP-11', ' ',
        OUT,
		true,
        button_dispatch,ABOUT_POP11 ,
        about_pop11 ) -> button_table("pop11_intro");

    consbutton( ' PROLOG',
        false,
        CHUNKY,
        ABOUT_PROLOG,
        true,
        156,;;;106,
        281,
        1,
        ' ', '  PROLOG', ' ',
        OUT,
		true,
        button_dispatch,ABOUT_PROLOG ,
        about_prolog ) -> button_table("prolog_intro");

    consbutton( 'lisp ',
        false,
        CHUNKY,
        ABOUT_LISP,
        true,
        244,;;;194,
        281,
        1,
        ' ','   Common', '       Lisp ',
        OUT,
		true,
        button_dispatch,ABOUT_LISP ,
        about_lisp ) -> button_table("cl_intro");

    consbutton( ' SML ',
        false,
        CHUNKY,
        ABOUT_SML,
        true,
        332,;;;282,
        281,
        1,
        ' ','  Standard', '      ML ',
        OUT,
		true,
        button_dispatch,ABOUT_SML ,
        about_ml ) -> button_table("sml_intro");

    consbutton( '  OOP',
        false,
        CHUNKY,
        ABOUT_OOP,
        true,
        430,;;;370,
        281,
        1,
        '     Object ', '   Oriented ', 'Programming',
        OUT,
		true,
        button_dispatch,ABOUT_OOP ,
        about_oop ) -> button_table("oop_intro");

    consbutton( '? ',
        false,
        CHUNKY,
        DEMOTOOL_TUTORIAL,
        true,
        475,
        41,
        1,
        'usesHelpButton', 'demonstration', 'system... ',
        OUT,
		true,
        tutorial1,DEMOTOOL_TUTORIAL,
        'default.desc' ) -> button_table("what_intro");

    consbutton( 'lpin1hr ',
		false,
		CHUNKY,
		POPLOG_TUTORIAL,
		true,
        475,
		121,
		1,
        '     Learn', '   POPLOG ', '   in an hour..',
        OUT,
		true,
        button_dispatch, POPLOG_TUTORIAL ,
        'default.desc' ) -> button_table("lpiah_intro");

    [
        demo_info
        demo_up
		demo_exit
        x_intro      mlp_intro  uel_intro  ved_intro
        im_intro     olh_intro  sl_intro   pop11_intro
        prolog_intro cl_intro   sml_intro  oop_intro
       ]->level_intro_index_buttons;

enddefine;




define initialise_buttons();
    ;;; sets up all the button record classes
    ;;; and places the identifiers in the corresponding
    ;;; list;
    XtVaSetValues(image_in_wr ,XptVaArgList([{font ^times_bold_12}]));
    XtVaSetValues(image_out_wr,XptVaArgList([{font ^times_bold_12}]));
    set_ss_button();
    set_intro_tool_buttons();
    set_level_intro_buttons();
    set_level_two_buttons();
    set_level_four_buttons();
    set_level_six_buttons();
    set_level_one_buttons();

 	[ slide_show   ] -> buttons_to_overlay;

enddefine;

endsection;
