/* --- Copyright University of Sussex 1991.  All Rights Reserved. ---------
 > File:            C.all/x/ui/lib/popdemo.p
 > Version :        1.82
 > Purpose:         create the ISL POPLOG DEMO SYSTEM
 > Author:          J.D.POSTOYKO, May 1991
 > Documentation:
 > Related Files:
*/

section $-demotool => pop_ui_demotool reset_pop_ui_demotool     	;
compile_mode:pop11 +strict ;
uses popxlib;
include xt_constants;
include xdefs.ph;
uses pop_ui_confirm;
vars	subject_list=[];

define go();
	;;; will be redefine when lib mshand loaded
	;;; otherwise should the system try to run it
	;;; which it shouldnt, then simply prints
	;;; a message
	'lib mshands not loaded'=>
enddefine;

include xdefs.ph;
compile('$usepop/pop/x/ui/demo/src/code/demotool_vars.p');
compile('$usepop/pop/x/ui/demo/src/code/rasterfile_utils.p');


;;; active variable: iscolour
;;; Returns true if the demotool is connected to a color display

vars screenType = false,
 	screen_depth = false;

define active isrgb;

	#_IF DEF HPUX
	false;
	#_ELSE
	unless screen_depth then
		fast_XptValue($-poplog_ui$-pop_ui_app_shell, XtN depth) -> screen_depth;

	endunless;
	screen_depth fi_> 1;
	#_ENDIF

enddefine;



define constant initialise_x_dependent_vars();

	#_IF DEF IRIS
	copy_fixed('-*-times-medium-r-*--*-80-*-*-*-*-*-*') -> times_bold_12;
    copy_fixed('-*-courier-medium-r-*--*-80-*-*-*-*-*-*') ->font18;
	#_ELSEIF DEF SUN
	copy_fixed('-*-times-medium-r-*--*-120-*-*-*-*-*-*') -> times_bold_12;
    copy_fixed('-*-courier-bold-r-*--*-120-*-*-*-*-*-*') ->font18;
	#_ELSE
	copy_fixed('-*-times-medium-r-*--*-120-*-*-*-*-*-*') -> times_bold_12;
    copy_fixed('-*-courier-bold-r-*--*-120-*-*-*-*-*-*') ->font18;
	#_ENDIF

	if isrgb then

		;;;#_IF XOPENLOOK

    	1->FGC ;
    	3->BGC ;
    	2->BGC2;
    	1->BLACK ;
    	19->BLUE  ;
    	18->CYAN ;
    	35->LED_ON   ;
    	34->LED_OFF    ;
    	33->RED_LED_ON;
    	32->RED_LED_OFF  ;
    	3->CMD_BUTTON_IN_COLOR;
    	2->CMD_BUTTON_OUT_COLOR;
    	1->CMD_BUTTON_TEXT_COLOR;
        0->CMD_BUTTON_LIGHT_LINE;
        1->CMD_BUTTON_DARK_LINE;
        1->CHUNKY_BUTTON_TEXT_COLOR ;
        '/RGB'->screenType;


		;;;#_ELSE
/*
	;;; these for a color;

    	copy_fixed('times-roman-12')->times_bold_12;
    	copy_fixed('*courier*bold-r-*14*')->font18;
    	1->FGC;
    	5->BGC ;
    	5->BGC2;
    	1->BLACK ;
    	19->BLUE ;
    	18->CYAN ;
    	47->LED_ON  ;
    	34->LED_OFF ;
    	27->RED_LED_ON ;
    	43->RED_LED_OFF ;
    	5->CMD_BUTTON_IN_COLOR ;
    	5->CMD_BUTTON_OUT_COLOR;
        0->CMD_BUTTON_LIGHT_LINE;
        1->CMD_BUTTON_DARK_LINE;
        11->CHUNKY_BUTTON_TEXT_COLOR ;
    	11->CMD_BUTTON_TEXT_COLOR ;
        '/RGB'->screenType;
		*/
		;;;#_ENDIF

	else
		;;; these are for a mono machine;

    	1->FGC ;
    	0->BGC ;
    	1->BGC2 ;
    	1->BLACK ;
    	1->BLUE  ;
    	1->CYAN ;
    	1->LED_ON ;
    	0->LED_OFF ;
    	1->RED_LED_ON ;
    	0->RED_LED_OFF ;
    	0->CMD_BUTTON_IN_COLOR;
    	0->CMD_BUTTON_OUT_COLOR;
    	1->CMD_BUTTON_TEXT_COLOR ;
        0->CMD_BUTTON_LIGHT_LINE ;
        1->CMD_BUTTON_DARK_LINE ;
        1->CHUNKY_BUTTON_TEXT_COLOR;
       	'/MONO'->screenType;;

	endif;
	;;; we have to know how big the buttons are before loading in button data
	rasterfile_info('$usepop/pop/x/ui/demo/src/images/'sys_><screenType sys_><'/chunky_button_in.rs');
	ras_width-> CHUNKY_BUTTON_WIDTH;
	ras_height->CHUNKY_BUTTON_HEIGHT;
	times_bold_12->chrs_font;

enddefine;


vars procedure button_graphics;
if popmemlim fi_< 2000000 then 2000000 ->popmemlim; endif;

vars intro_tool_active = false;
exload_batch;
uses sigdefs;
uses XptValue;
uses XptVaArgList;
uses xt_widget;
uses xt_popup;
uses xt_display;
uses xt_callback;
uses xt_event;
uses xt_resource;
uses xt_composite;
uses xt_widgetinfo;
uses xt_action;

constant
    XpwGraphic          =   XptWidgetSet("Poplog")("GraphicWidget"),
    XpwPixmap           =   XptWidgetSet("Poplog")("PixmapWidget"),
    TransientShell    =   XptWidgetSet("Toolkit")("TransientShellWidget"),
    ApplicationShell    =   XptWidgetSet("Toolkit")("ApplicationShellWidget"),
    ;

XptLoadProcedures 'demotool'
XRaiseWindow
XLowerWindow
XMoveWindow
XIconifyWindow
XMapWindow
XUnmapWindow
XFlush
XPending
XBell
XWarpPointer;
endexload_batch;

loadinclude xt_constants;
vars	subject_list=[];

compile('$usepop/pop/x/ui/demo/src/code/slide_data.p');
;;; we have to know how big the buttons are before loading in button data

compile('$usepop/pop/x/ui/demo/src/code/button_data.p');
compile('$usepop/pop/x/ui/demo/src/code/demotool_utils.p');


/**************************************************************
          Routines to reset attributes of the demotool.
***************************************************************/

define constant  reset_demotool_appearance();
	if isrgb then
		;;;    cmap_entry_rgb(CMD_BUTTON_TEXT_COLOR,255,255,0);
    	XpwChangeColor(current_graphic_widget,  LED_OFF , 0, 170, 0);
    	XpwChangeColor(current_graphic_widget,  LED_ON, 140, 255, 140);
    	XpwChangeColor(current_graphic_widget,  20, 0,0, 255);

    	BGC->XptValue(demotool_graphic,XtN foreground);
	endif;
	#_IF XOPENLOOK
    XtVaSetValues(demotool_graphic,  XptVaArgList([{font ^times_bold_12}]));
	#_ENDIF
enddefine;

/*   reset demotool graphic  ensures that the correct drawing surface    */
/* is restored with the correct set of buttons after calls to intro tool */
/* have been made */

define reset_demotool_graphic();
    false->intro_tool_active;
    clear_area(0,0, WINDOW_WIDTH , WINDOW_HEIGHT);
    activate(hd(DEMO_PATH), current_graphic_widget);
    tl(DEMO_PATH)->DEMO_PATH;

enddefine;

/* reset_demotool_at_level_one differs from other resets  */
/* in that it ensures the dt starts off with the four top */
/* level buttons                                          */

define reset_demotool_at_level_one();
    false->intro_tool_active;
    XtRemoveAllCallbacks( current_graphic_widget,XtN buttonEvent);
	[]->DEMO_PATH ;"AT_START"::DEMO_PATH->DEMO_PATH;
	clear_area(0,0,WINDOW_WIDTH,WINDOW_HEIGHT);
	activate(level_one_buttons,demotool_graphic);
 	XtAddCallback( demotool_graphic,
        XtN buttonEvent,
        demotool_mb_cb,
        "clicked");

enddefine;

/* demotool sensitive allows the active surface to be made     */
/* active or non responsive wrt the mouse                      */
/* note it always removes callbacks first to prevent multiple  */
/* assignments of a callback                                   */


define  constant demotool_sensitive( okay );
	lvars okay;

	XtRemoveAllCallbacks( current_graphic_widget,
        XtN buttonEvent);
	if okay then
    	XtAddCallback( current_graphic_widget ,
        	XtN buttonEvent,
        	demotool_mb_cb,
        	"clicked");
	endif;

enddefine;


/****************** end of resetting procedures ************/


/****************** Control routines ************************/

/* give_demo_summary displays a text file in the summary  */
/* window, and activates the slide show button           */

define procedure give_demo_summary(button_id);
	lvars button_id;

	if last_chunky_button_selected then
     	button_table(last_chunky_button_selected)->extract;
    	if extract.button_summary_file then
        	if not(button_table("slide_show").button_sensitive) then
            	sensitise("slide_show",true);
        	endif;
        	show_a_summary_file('$usepop/pop/x/ui/demo/descriptions/'sys_><extract.button_summary_file);
        	demotool_graphic->current_graphic_widget;
    	endif;
	endif;

enddefine;


/* button_dispatch takes the encoded button id and         */
/* performs some action accordingly;                      */
/* the code was SPECIFICALLY written for the demo system */

vars activate_demotool;

define procedure give_information(subject);
	lvars subject;
  	show_intro_tool(subject);
  	;;;reset_demotool_graphic();

enddefine;

define  constant  button_dispatch( button_id ); /*
button_id = an unique identifier associated with each button  :int */
    lvars button_id, extract, answer;


	if not (doing_something) then
		if button_id then
    		switchon button_id ==
			case NEXT_PAGE then
        		current_position  fi_+1 -> current_position;
				if ((current_position = 2) and (length(subject_list) fi_>1)) then
					true->min_lim
				endif;
            	if min_lim then
                	sensitise("intro_previous",true);
					false->min_lim;
            	endif;
            	sensitise("intro_next",true);

    			if current_position >= length(subject_list) then
					length(subject_list) -> current_position;
					sensitise("intro_next", false);
					true-> max_lim;
				endif;

            	switchon demotool_size ==
            	case SLIDESHOW then
                	display_using(subject_list( current_position));
            	case RUNDEMO then
 		   			display_text(xorigin,yorigin, subject_list( current_position), demotool_graphic);
            	endswitchon;
        		false->button_selected;
	    		put_page_No_of();

			case PREVIOUS_PAGE then
        		current_position  fi_- 1 ->current_position ;
            	if max_lim then
                	sensitise("intro_next",true);
                	false->max_lim;
            	endif;
            	sensitise("intro_previous",true);
    			if current_position <= 1 then
					1 -> current_position;
					sensitise("intro_previous",false);
					true -> min_lim;

         		endif;
            	switchon demotool_size ==
            	case SLIDESHOW then
                	display_using(subject_list( current_position));
            	case RUNDEMO then
 					display_text(xorigin,yorigin, subject_list( current_position), demotool_graphic);
            	endswitchon;
        		false->button_selected;
            	true->min_lim;
	    		put_page_No_of();

			case SAVE_PAGE then
 				if not(intro_to_poplog_stackmark) then
                	sensitise("intro_restore",true);
				endif;
				sensitise("intro_save",true);
				current_position -> intro_to_poplog_stackmark  ;
			case RESTORE_PAGE then
				if intro_to_poplog_stackmark then
					sensitise("intro_restore",true);
					intro_to_poplog_stackmark -> current_position   ;
    				if current_position <= 1 then
						sensitise("intro_previous",false);
						true -> min_lim;
            		else
						sensitise("intro_previous",true);
						false -> min_lim;
					endif;
    				if current_position >= length(subject_list) then
						sensitise("intro_next", false);
						true-> max_lim;
					else
						sensitise("intro_next", true);
						true-> max_lim;
					endif;
            	endif;
				display_text(xorigin,yorigin, subject_list( current_position), demotool_graphic);
        		false->button_selected;
	    		put_page_No_of();

    		case EXIT_DEMOTOOL then
            	pop_ui_confirm('Please confirm exit from the demotool',
                	[Exit Cancel],2,false,false)->answer;
        		if answer == 1 then
            		reset_demotool();
            	else
        			xor_state("demo_exit");
					xor_state("demo_exit");

        		endif;

				;;;		false->button_selected;

        	case X_DEMO then
     			#_IF XOPENLOOK
  				lib XolDemos;
				#_ELSEIF XMOTIF
				lib XmDemos;
    			#_ELSEIF XMIT
 				'Sory no demo available'=>
    			#_ENDIF;

	        case  BLOCKS_DEMO then lib msblocks;go();
			case  ELIZA_DEMO then lib eliza;
            	eliza();

    		case INFORMATION then
        		exacc (2) raw_XUnmapWindow(summary_widget_display,
            		summary_widget_window);
        		if button_table("slide_show").button_sensitive then
            		sensitise("slide_show", false);
        		endif;
        		give_information(about_the_pds);
				false->button_selected;
			endswitchon;

			if last_cmd_button_selected then
    			if button_id == SLIDE_SHOW then
        			last_chunky_button_selected->last_demo_button_selected;
        			button_table(last_chunky_button_selected)->extract;
					switchon extract.button_int
					case == EXCAP_DEMO then show_projector(excap_slides);
					case == FAUST_DEMO then show_projector(faust_slides);
					case == ARBS_DEMO then show_projector(arbs_slides);
					case == TASKER_DEMO then show_projector(tasker_slides);
					case == IVE_DEMO then show_projector(ive_slides);
					case == HEAD_DEMO then show_projector(xmed_slides);
					case == KBS_DEMO then show_projector(sat_slides);
					case == WALKER_DEMO then show_projector(walker_slides);
					endswitchon;
    			endif;
				xor_state(last_cmd_button_selected);
				false->last_cmd_button_selected;
			endif;

            if button_id = FLEX_DEMO then
        		button_table(last_chunky_button_selected)->extract;
				show_intro_tool(extract.button_summary_file);
   			endif;

            if button_id = RULES_DEMO then
        		button_table(last_chunky_button_selected)->extract;
				show_intro_tool(extract.button_summary_file);
   			endif;

            if button_id = NEURAL_DEMO then
        		button_table(last_chunky_button_selected)->extract;
				show_intro_tool(extract.button_summary_file);
   			endif;


			if button_id >= ABOUT_X and button_id <= ABOUT_OOP then
        		button_table(last_chunky_button_selected)->extract;
				show_intro_tool(extract.button_summary_file);
   			endif;

		endif;
		exitfrom(button_dispatch);
		;;;		false->button_selected;

	endif;

enddefine;

/* button graphics takes care of visualising the buttons in the correct */
/* state */

define constant button_graphics(button_selected);
	lvars button_selected;

	if not (doing_something) then
		if button_selected then
    		if (button_selected and button_selected /= SPECIAL_EXCEPTION ) then
            	button_selected -> last_button_selected;
        		button_table(button_selected) -> extract;
				if extract.button_shape == CHUNKY then
           			if not (intro_tool_active) then
 						if button_selected /= last_chunky_button_selected then
                			if last_chunky_button_selected then
                        		xor_state(last_chunky_button_selected);
                			endif;;
                			xor_state(button_selected);
                			button_selected -> last_chunky_button_selected;
            			endif;
           			endif;

   				elseif extract.button_shape == CMD then
					if last_chunky_button_selected then
 		   				if button_selected /= last_cmd_button_selected then
                   			xor_state(button_selected);
    		    		endif;
                		button_selected -> last_cmd_button_selected;

            		elseif ((extract.button_int fi_> NEXT_PAGE)
               			and  (extract.button_int fi_< SAVE_PAGE)) then
            			if last_chunky_button_selected then
 		   					if button_selected /= last_cmd_button_selected then
                   				xor_state(button_selected);
    		    			endif;
                			button_selected -> last_cmd_button_selected;
            			endif;
					endif;
   				endif;

				if extract.button_sensitive then
        			apply(extract.button_variable,extract.button_procedure);
				endif;
    		endif;

    		if button_selected == SPECIAL_EXCEPTION then
				;;; Normally, this block would be released by the
				;;; dismiss buton.... possibly redundent now but may be of use
      			false->>intro_tool_active -> button_selected;
    		endif;

    		if button_selected=="demo_up" then
				false -> intro_to_poplog_stackmark  ;
				switchon demotool_size ==
				case RUNDEMO then
      				if not(hd(DEMO_PATH)="AT_START") then
						;;; display previous page of buttons
            			clear_area(0,0, WINDOW_WIDTH , WINDOW_HEIGHT);
            			activate(hd(DEMO_PATH), current_graphic_widget);
            			if not (intro_tool_active) then
            				tl(DEMO_PATH)->DEMO_PATH;
            			endif;
            			sensitise("demo_info",true);
            		else
                		activate_demotool("host_types");
        			endif;

    				exacc (2) raw_XUnmapWindow(summary_widget_display,
        				summary_widget_window);
					1->current_position;
					true  -> button_table("intro_next").button_sensitive;
					false -> button_table("intro_previous").button_sensitive;
        			false -> button_table("intro_restore").button_sensitive;
        			false -> button_selected;
				case SLIDESHOW then
    				false-> image_has_mono_and_rgb;
					times_bold_12->chrs_font;
					#_IF XOPENLOOK
    				XtVaSetValues(current_graphic_widget,
        				XptVaArgList([{font ^chrs_font }]));
					#_ENDIF

					demotool_sensitive(false);
					set_demotool_size(RUNDEMO);
					demotool_sensitive(true);
    				504->button_table("demo_exit").button_x_pos;
    				true-> button_table("demo_exit").button_sensitive;
    				activate(level_two_buttons,current_graphic_widget);
    				xor_state(last_demo_button_selected);
    				last_demo_button_selected->>last_chunky_button_selected ->button_on_which_mouse_pressed;
					1->current_position;
            		sensitise("demo_info",true);
					true  -> button_table("intro_next").button_sensitive;
					false -> button_table("intro_previous").button_sensitive;
        			false -> button_table("intro_restore").button_sensitive;
        			false -> button_selected;
				endswitchon;
    		endif;
			;;;    false -> button_selected;
		else

		endif;
	endif;
enddefine;


/***********************************************
                Callback routines
************************************************/

/*  demotool mb cb is used to do the main event processing */

define constant demotool_mb_cb(w, client_data, call_data);
    lvars w client_data call_data x y mouse_button extract
        last_active_level_buttons the_button ex;

	if not (doing_something) then
    	exacc ^int call_data->mouse_button ;
    	mouse_button->the_button_clicked_on; ;;; global record
    	XptValue(w,XtN mouseX)->x;
    	XptValue(w,XtN mouseY)->y;
    	switchon mouse_button
		case = -1 then
        	check_x_y(x,y)-> the_button;
			if the_button = button_on_which_mouse_pressed then
            	;;; check that they are both not false
            	if ((the_button = false) and
                    	(button_on_which_mouse_pressed = false)) then
                	false->had_input;
            	else
              		true->had_input;
					button_on_which_mouse_pressed->button_selected;
            	endif;
        	else
            	if button_on_which_mouse_pressed = false then
                	;;; do nothing
            	else
					button_table(button_on_which_mouse_pressed)->ex;
        			set_button(ex,OUT);
					if button_table("slide_show").button_sensitive then
						if last_chunky_button_selected = button_on_which_mouse_pressed then
							sensitise("slide_show",false);
						endif;
					endif;
            	endif;
         		false -> button_selected;
        	endif;
		case  = 1 then
        	check_x_y(x,y)-> the_button;
        	if the_button then
            	false->button_selected;
           		if the_button then
					if button_table(the_button).button_sensitive  then
			  			button_table(the_button)->ex;
        		  		set_button(ex,IN);
        		  		the_button -> button_on_which_mouse_pressed;
        			endif;
		  		endif;
        	endif;

		endswitchon;
		XptDeferApply(button_graphics(%button_selected%));
		XptSetXtWakeup();
    	false -> button_selected;
	endif;

enddefine;



define activate_demotool(level);
	lvars level;

	if not (doing_something) then
     	XtRemoveAllCallbacks( current_graphic_widget,XtN buttonEvent);

		switchon level ==
		case "level_one" then
			XptDeferApply( reset_demotool_at_level_one(%%));
			XptSetXtWakeup();
		case "host_types" then
    		XptDeferApply(show_poplog_hosts(%%));
    		XptSetXtWakeup();
    		XtAddCallback( demotool_graphic,
        		XtN buttonEvent,
        		demotool_mb_cb3,
        		"clicked");
		endswitchon;
	endif;

enddefine;

/* demotool mb cb2 is used to do event processing where the actual location */
/* of a mouse event is not important wrt HELP */

define  constant demotool_mb_cb2(w, client_data, call_data);
    lvars w client_data call_data x y mouse_button;
    exacc ^int call_data->mouse_button ;
	;;; only dispatch if lh MB is pressed
	if mouse_button = -1 then
        true->release_lock;
 	endif;
enddefine;

/* demotool mb cb3 is used to do event processing where the actual location */
/* of a mouse event is not important */

define  constant demotool_mb_cb3(w, client_data, call_data);
    lvars w client_data call_data x y mouse_button extract last_active_level_buttons;
    exacc ^int call_data->mouse_button ;
   	mouse_button->the_button_clicked_on; ;;; global record
	;;; only dispatch if lh MB is pressed
	if mouse_button fi_< 0 then
        XptDeferApply(activate_demotool(%"level_one"%));
		XptSetXtWakeup();
	endif;

enddefine;

/*traps the quit request from wm menu */

define constant exit_action(w, event, params, num_params);
    lvars w, event, params, num_params;
    if w = current_demotool_widget then
        if pop_ui_confirm('Please confirm exit from the demotool'
        		,[Exit Cancel],2,false,false) == 1 then
            reset_demotool();
        else
        endif;
    	xor_state("demo_exit");
    endif;

enddefine;


/*********************** End of callbacks *************************/

/*********************** end of Control routines ******************/


/*********************** general demotool routines ****************/

/* simply puts the POPLOG 14 banner on the window */
define  constant procedure initial_display();
	clear_area(0,0,WINDOW_WIDTH,WINDOW_HEIGHT);
	if isrgb then
		XpwCopyFrom(demotool_graphic,banner_img,0,0,447,68,60,50 );
	else
		XpwCopyFrom(demotool_graphic,banner_img,0,0,459,140,60,50 );
	endif;
	decorate_window(false);

enddefine;

/* identifies the X server, and machine upon which POPLOG    */
/* is running, and puts up a display showwing all the severs */
/* and machine type it can run on, identifying what it is on */

define  constant procedure show_poplog_hosts();
	lvars item poplog_host_list machine_type vstep = 0;
	lvars h_pad= -20,os_type,cpu_type,index;
    lvars v_pad = -10;
	#_IF XOPENLOOK
    XtVaSetValues(demotool_graphic, XptVaArgList([{font ^times_bold_12}]));
	#_ENDIF
	CMD_BUTTON_TEXT_COLOR-> XptValue(demotool_graphic,XtN foreground);
	initial_display();
    ;;; get the machine type, cons it to a string
    hd(sys_machine_type)sys_><''->machine_type;
	move_image( h_pad fi_+190,145  fi_+  v_pad  ,210,140,'',OUT);
	XpwCopyFrom(demotool_graphic,machines_img,0,0,160,122, h_pad fi_+220,150   fi_+  v_pad  );
	move_image( h_pad fi_+45,140 fi_+  v_pad  ,115,90,'X11R4:',IN);
	move_image( h_pad fi_+52,167 fi_+  v_pad  ,10,10,'',OUT);
	move_image( h_pad fi_+52,167 fi_+18 fi_+  v_pad  ,10,10,'',OUT);
	move_image( h_pad fi_+52,167 fi_+36 fi_+  v_pad  ,10,10,'',OUT);
    #_IF XOPENLOOK
	move_image( h_pad fi_+52,167 fi_+  v_pad  ,10,10,'',IN);
	#_ELSEIF XMOTIF
	move_image( h_pad fi_+52,167 fi_+18 fi_+  v_pad  ,10,10,'',IN);
    #_ELSEIF XMIT
	move_image( h_pad fi_+52,167 fi_+36 fi_+  v_pad  ,10,10,'',IN);
	#_ENDIF;
	XpwDrawString(demotool_graphic, h_pad fi_+70,175 fi_+  v_pad  , 'OpenLook');
    XpwDrawString(demotool_graphic, h_pad fi_+70,175 fi_+  v_pad   fi_+18,'Motif');
	XpwDrawString(demotool_graphic, h_pad fi_+70,175 fi_+36 fi_+  v_pad  ,'MIT');
	draw_block( h_pad fi_+160,170 fi_+  v_pad  ,30,2,BLUE);
	draw_block( h_pad fi_+191,171 fi_+  v_pad  ,60,2,BLUE);
	move_image( h_pad fi_+430,140 fi_+  v_pad  ,130,193,'HOSTS:',IN);
	draw_block( h_pad fi_+320,229 fi_+  v_pad  ,80,2,BLUE);
	draw_block( h_pad fi_+400,230 fi_+  v_pad  ,30,2,BLUE);
	poplog_hosts->poplog_host_list; ;;; currently hard wired jdp

	fast_for item in poplog_host_list do
		XpwDrawString(demotool_graphic, h_pad fi_+456,175 fi_+vstep fi_+  v_pad  , hd(poplog_host_list));
 	   	move_image( h_pad fi_+437,148 fi_+vstep fi_+18 fi_+  v_pad  ,10,10,'',OUT);
 	 	tl(poplog_host_list)->poplog_host_list;
		vstep fi_+18->vstep;
	endfast_for;
	1 -> index;
   	switchon hd(sys_machine_type) ==

	case "vax" then
		6->index;
	case "iris" then
		5->index;
	case "sun3" then
		2->index;
	case "sun4" then
		1->index;
	case "hp9000" then
		4->index;
    case "decstation" then
 		3->index;
    case "symmetry" then
		8->index;
    endswitchon;
	if sys_processor_type = [80386] then
		7->index;
    endif;

 	move_image( h_pad fi_+437,148 fi_+ ((18*index)) fi_+ v_pad  ,10,10,'',IN);

enddefine;


/* stand by mode displays the available platforms which run poplog */
/* and indicates on which it is currently running */
define constant standby_mode();
    demotool_sensitive(false);
    XtAddCallback( demotool_graphic,
        XtN buttonEvent,
        demotool_mb_cb3,
        "clicked");
	show_poplog_hosts();
	prompt_response(20,270,1);

    demotool_sensitive(false);
	[]->DEMO_PATH ;"AT_START"::DEMO_PATH->DEMO_PATH;

enddefine;


/* show_intro_tool displays the contents of  list of files, */
/* one page at a time                                       */

define constant show_intro_tool( list );/*
list  =  a list of ASCII files to be displayed
*/
	lvars list button buttons=level_intro_buttons;
	if not(doing_something) then
		true->doing_something;
    	XptAppTryEvents( XptCurrentAppContext );
		#_IF XOPENLOOK
    	XtVaSetValues(demotool_graphic, XptVaArgList([{font ^times_bold_12}]));
		#_ENDIF
    	BGC -> XptValue(demotool_graphic, XtN background); ;;; 21 was cyan
    	demotool_graphic->current_graphic_widget;
    	true-> button_table("intro_save").button_sensitive;
    	display(level_intro_buttons);
		if not(isrgb) then
    		draw_block(495,63,100,75,BGC2); ;;; changed 0 to 61 for decoration
    		draw_block(495,75,7,208,BGC2);
    		draw_block(573,75,4,208,BGC2);
    		draw_block(495,273,100,197,BGC2);
		endif;
		#_IF XOPENLOOK

    	XtVaSetValues(demotool_graphic,
        	XptVaArgList(
            	[{font ^times_bold_12}]));
		#_ENDIF

		demotool_sensitive(true);
		display_intro_text(10,65,10,WINDOW_HEIGHT-4,WINDOW_WIDTH - 50,false,list);
	endif;
	false->doing_something;

enddefine;



/* reset pop ui demotool kills of the widgets */

define global procedure reset_pop_ui_demotool();
	XtDestroyWidget(demotool_graphic);
	XtDestroyWidget(demotool_widget);

    if SLIDESHOW_HAS_BEEN_SEEN then
		XtDestroyWidget(demotool_graphic2);
		XtDestroyWidget(demotool_widget2);
    endif;

	XtDestroyWidget(summary_graphic);
	XtDestroyWidget(summary_widget);
	false->demotool_widget ;
	false->demotool_widget2 ;
	false->summary_widget ;
	false->demotool_graphic ;
	false->demotool_graphic2 ;
	false->summary_graphic ;
    []-> DEMO_PATH;"AT_START"::DEMO_PATH->DEMO_PATH;
    false->intro_to_poplog_stackmark;
    false->button_on_which_mouse_pressed;
    false->last_active_level ;
    false->last_button_selected;
    false->last_button_level;
    false->requested_to_stop;
    true->button_selected;
enddefine;


/* reset demotool tidies up and resets the demotool ready for another run */
/* is used internally, and is activated by the request to quit/exit the  */
/* demotool     														 */

define  reset_demotool();



    demotool_graphic->current_graphic_widget;
    demotool_widget->current_demotool_widget;

    exacc (2) raw_XUnmapWindow(summary_widget_display,
        summary_widget_window);

    exacc (2) raw_XUnmapWindow(demotool_widget_display,
        demotool_widget_window);

    if SLIDESHOW_HAS_BEEN_SEEN then

    	exacc (2) raw_XUnmapWindow(demotool_widget2_display,
          	demotool_widget2_window);
    endif;
    []-> DEMO_PATH;"AT_START"::DEMO_PATH->DEMO_PATH;
    false->intro_to_poplog_stackmark;
    false->button_on_which_mouse_pressed;
    false->last_active_level ;
    false->last_button_selected;
    false->last_button_level;
    false->requested_to_stop;
    true->button_selected;


enddefine;


/* general hook from the demo tool to the pui it is the same on all X */
/* implementations, the minor changes being made by mkdemotool       */

define global pop_ui_demotool();

	initialise_x_dependent_vars();

    false->button_selected;
    unless XptDefaultDisplay then
        XptDefaultSetup();
    endunless;

    if not(demotool_widget) then
    	mkdemotool();
    else
        exacc (2) raw_XMapWindow(demotool_widget_display,
            demotool_widget_window);
    endif;

    exacc (2) raw_XUnmapWindow(summary_widget_display,
        summary_widget_window);

    standby_mode();
    XtRemoveAllCallbacks( current_graphic_widget, XtN buttonEvent);

    XtAddCallback( demotool_graphic,
        XtN buttonEvent,
        demotool_mb_cb3,
        "clicked");

enddefine;

endsection



/******************* end of  general demotool routines ******************/

/* --- Revision History ---------------------------------------------------
--- Julian Clinton, 15/10/92
	Modified show_host_type.
*/
