/* --- Copyright University of Sussex 1991.  All Rights Reserved. ---------
 > File:            C.all/x/ui/lib/demotool_utils.p
 > Version :        1.70
 > Purpose:         utilities for the the ISL POPLOG DEMO SYSTEM
 > Author:          J.D.POSTOYKO, May 1991
 > Documentation:
 > Related Files:
*/

section $-demotool;

/* =>demotool_graphic_cmap,demotool_graphic_cmap2 cmap_entry_rgb
draw_block;
*/
compile_mode:pop11 +strict ;

include vedfile_struct.ph;
include xdefs.ph;
include xpt_xscreen.ph;

;;; 07/01/92 jdp if xmotif lost
#_IF DEF XMOTIF
exload_batch;
;;; force DialogShell to be loaded to get at the mapping libraries
XptWidgetSet("Motif")("DialogShellWidget")->;
endexload_batch;
#_ENDIF
;;; jdp eom


vars demotool_graphic_cmap, demotool_graphic_cmap2;




define clone_cmap(graphic)->rgb_map;
    lvars graphic, rgb_map, i , range,
        def_cmap = exacc :XScreen (XtScreen(graphic)).cmap;
    lvars basic_colors = [%lvars i;
    	fast_for i from 0 to 255 do
        	{%i, XpwQueryColor(graphic, i)%}
    	endfast_for%];

    XpwCreateColormap(graphic);
    XpwAllocColor(graphic, 1,1,1) ->text_color;
   	text_color or 0 -> text_color;

    XpwAllocColorRange(graphic, 254, 0,0,0, 255,255,255)->range;
    fast_for i in basic_colors do
        XpwChangeColor(graphic, explode(i));
    endfast_for;
    range->rgb_map;

enddefine;


vars def_basic_colors;

define get_def_cmap(graphic);
    lvars graphic, rgb_map, i , range,
        def_cmap = exacc :XScreen (XtScreen(graphic)).cmap;
    lvars basic_colors = [%lvars i;
    	fast_for i from 0 to 254 do
        	{%i, XpwQueryColor(graphic, i)%}
    	endfast_for%];
    basic_colors->def_basic_colors;

enddefine;




define motif_openwin_cmap(graphic);
/*
  graphic: widget - type graphic
  under motif
  changes lower 30 colour entries to be like
  openlook
	*/
    lvars graphic;


	#_IF XOPENLOOK
    XpwChangeColor(graphic,31,16:00,16:00,16:FF);
    XpwChangeColor(graphic,30,16:00,16:00,16:00);
    XpwChangeColor(graphic,20,16:00,16:00,16:FF);
    XpwChangeColor(graphic,12,16:FF,16:00,16:00);
    XpwChangeColor(graphic,18,16:C0,16:FF,16:FF);
    XpwChangeColor(graphic,19,16:FF,16:CB,16:FF);

	#_ELSE

	#_IF DEF IRIS
    XpwChangeColor(graphic,00,16:FF,16:FF,16:FF);
	#_ENDIF

    XpwChangeColor(graphic,1,16:0,16:0,16:0);
    XpwChangeColor(graphic,2,16:5B,16:E5,16:E5);
    XpwChangeColor(graphic,3,16:52,16:CE,16:CE);
    XpwChangeColor(graphic,4,16:2D,16:72,16:72);
    XpwChangeColor(graphic,5,16:B3,16:FF,16:FF);
    XpwChangeColor(graphic,6,16:40,16:91,16:C0);
    XpwChangeColor(graphic,7,16:FF,16:FF,16:FF);
    XpwChangeColor(graphic,8,16:AB,16:A0,16:FF);
    XpwChangeColor(graphic,9,16:A1,16:D6,16:D6);
    XpwChangeColor(graphic,10,16:D6,16:A1,16:CD);
    XpwChangeColor(graphic,11,16:FF,16:E1,16:FF);
    XpwChangeColor(graphic,12,16:FF,16:00,16:00);
    XpwChangeColor(graphic,13,16:CE,16:C0,16:FF);
    XpwChangeColor(graphic,14,16:FF,16:FF,16:C2);
    XpwChangeColor(graphic,15,16:00,16:FF,16:CC);
    XpwChangeColor(graphic,16,16:FF,16:FF,16:A0);
    XpwChangeColor(graphic,17,16:FF,16:C6,16:C0);
    XpwChangeColor(graphic,18,16:C0,16:FF,16:FF);
    XpwChangeColor(graphic,19,16:FF,16:CB,16:FF);
    XpwChangeColor(graphic,20,16:00,16:00,16:FF);
    XpwChangeColor(graphic,21,16:A0,16:A0,16:A0);
    XpwChangeColor(graphic,22,16:AA,16:E8,16:FF);
    XpwChangeColor(graphic,23,16:00,16:E8,16:FF);
    XpwChangeColor(graphic,24,16:44,16:BB,16:FF);
    XpwChangeColor(graphic,25,16:FF,16:FF,16:80);
    XpwChangeColor(graphic,26,16:B4,16:FF,16:B4);
    XpwChangeColor(graphic,27,16:73,16:E8,16:C0);
    XpwChangeColor(graphic,28,16:FF,16:A8,16:7D);
    XpwChangeColor(graphic,29,16:FF,16:93,16:7D);
    XpwChangeColor(graphic,30,16:00,16:00,16:00);
	#_ENDIF
enddefine;

uses xved;


/********************* general drawing routines **************************/

define constant load_image(name);
	/* name = name of rasterfile to be loaded onto current graphic widget*/
    lvars name temp p ;
    name->fname;
	if image_has_mono_and_rgb then
 		locchar_back(`/`,length(fname),fname)->p;p fi_-1->p;
 		allbutfirst(p,fname)->temp;
 		allbutlast(length(fname) fi_-p,fname) sys_><screenType sys_><temp->fname;
	endif;
    rasterfile_info(fname);
    ras_width -> ix;
    ras_height-> iy;
    demotool_rasterfile(fname)->arr;
   	move_image(1,39,885,614,'' ,OUT);
    move_image(
        (442 fi_-( ras_width >> 1 ))-1,
        40+(307 fi_-( ras_height >> 1 ))-1,
        ras_width+2,ras_height+2,'' ,OUT);
    XpwDrawImage(current_graphic_widget,
        ix,iy,
        (442 fi_-( ras_width >> 1 )),40+(307 fi_-( ras_height >> 1 )),
        arr);

enddefine;


define constant procedure set_colormap();
    XpwAllocColor(current_graphic_widget,10,10,255) -> text_color;
   	text_color or 0 -> text_color;
    XpwAllocColorRange(current_graphic_widget,220,0,0,0,255,255,255)->;

enddefine;



define constant  cmap_entry_rgb(n,r,g,b);/*
  b = blue  :int
  g = green :int
  r = red   :int
  n = cmap entry :int
*/
    lvars n r g b;
	if isrgb then
    	XpwChangeColor(current_graphic_widget,  n, r, g, b);
	endif;

enddefine;


define  constant  clear_area(x,y,w,h);/*
  h  = hight of block to be cleared :int
  w  = width  -:-        -:-
  xy = start xy of area to be cleared
*/
    lvars x, y, w, h bgc;

    if isrgb then
     	BGC2->bgc;
    else
     	BGC->bgc;
   	endif;
    dlocal %XptValue(current_graphic_widget, XtN foreground)% = bgc;
    XpwFillRectangle(current_graphic_widget, x, y, w, h);

enddefine;

define  constant  draw_block(x,y,w,h,c);/*
  c  = color to draw the block in :int
  h  = hight of block to be cleared :int
  w  = width  -:-        -:-
  xy = start xy of area to be cleared
*/
    lvars x, y, w, h, c;
    dlocal %XptValue(current_graphic_widget, XtN foreground)% =
        c;
    XpwFillRectangle(current_graphic_widget, x, y, w, h);

enddefine;


define  constant light_area( x,y,h,l );/*
  l  = length of area to be drawn :int
  h  = depth  of  -:-      -:-    :int
  xy = start xy -:-      -:-      :int
*/
    lvars x, y, h,l;
    dlocal %XptValue(current_graphic_widget, XtN foreground)% =
        CMD_BUTTON_OUT_COLOR;
    ;;; was 208
    XpwFillRectangle(current_graphic_widget, x, y, l, h);

enddefine;


define constant  dark_area(x,y,h,l);/*
  l  = length of area to be drawn :int
  h  = depth  of  -:-      -:-    :int
  xy = start xy -:-      -:-      :int
*/
    lvars x, y, h, l;
    dlocal %XptValue(current_graphic_widget, XtN foreground)% =     CMD_BUTTON_IN_COLOR;
    ;;; was 190
    XpwFillRectangle(current_graphic_widget, x, y, l, h);

enddefine;


define constant procedure move_image(x,y,l,h,s,p); /*
x = x coord
y = y coord
l = length of area
h = height of area
s = string which may be displayed
p = position in or out of screen
*/
	lvars x y l h s p;
	if p = OUT then
    	draw_block(x  , y   , l   , 1 , CMD_BUTTON_LIGHT_LINE);
    	draw_block(x  , y   , 1   , h , CMD_BUTTON_LIGHT_LINE);
    	draw_block(x  , y fi_+ h , l fi_+ 1 , 1 ,CMD_BUTTON_DARK_LINE );
    	draw_block(x fi_+ l, y   , 1   , h , CMD_BUTTON_DARK_LINE);
    	light_area(x+1,y+1,h fi_-2,l fi_-2);
	else
    	draw_block(x  , y   , l   , 1 ,CMD_BUTTON_DARK_LINE );
    	draw_block(x  , y   , 1   , h , CMD_BUTTON_DARK_LINE);
    	draw_block(x  , y fi_+ h , l fi_+ 1 , 1 , CMD_BUTTON_LIGHT_LINE);
    	draw_block(x fi_+ l, y   , 1   , h , CMD_BUTTON_LIGHT_LINE);
    	dark_area(x+1,y+1,h fi_-2,l fi_-2)
	endif;
    XpwDrawString(current_graphic_widget,x fi_+ 30,y fi_+ 20 ,s);

enddefine;



define constant set_bar(x,y,led,m,i);/*
x   = x offset
y   = y offset
led =
m   =
i   =
*/
    lvars x y led m l h  s i offset=0;

    85->l;
    23->h;
   	x fi_+ 4->x;
    fast_for i from 1 to 10 do
        ;;;     draw_block(x +offset,y fi_+5,LED_HEIGHT,LED_WIDTH,1);
        if i <= m then
            if led fi_>= i then
                draw_block(x +offset,y fi_+5,LED_HEIGHT -1, LED_WIDTH fi_-1,LED_ON);
            else
                draw_block(x +offset,y fi_+5,LED_HEIGHT -1, LED_WIDTH fi_-1,LED_OFF);
            endif;
        else ;;; this acts as a warning level
            if led fi_> =i then
                draw_block(x +offset,y fi_+5,LED_HEIGHT -1, LED_WIDTH fi_-1,RED_LED_ON);
            else
                draw_block(x +offset,y fi_+5,LED_HEIGHT -1, LED_WIDTH fi_-1,RED_LED_OFF);
            endif;
        endif;
        offset fi_+ 8->offset;
    endfast_for;

enddefine;

define constant amount_to_load(n);/*
n is the no of LEDS to illuminate in the bar graph
*/
	lvars n;
	set_bar(408,CMD_BUTTON_VERTICAL,n,10,10);

enddefine;


/************ end of general drawing routines ********************************/


/******** routines to display the correct button in response to mouse ********/


define constant draw_cmd_button_out(x,y,l,h,s,t,sensitive,has_LED);/*
  LED       = LED indicator :boolean
  sensitive = responds to mouse
  s         = label for button :str
  t         = label for button :str;;; optional but must be ''
  l         = length of area to be drawn :int
  h         = depth  of  -:-      -:-    :int
  xy        = start xy -:-      -:-      :int
*/
    lvars x y l h s t sensitive has_LED i;

    draw_block(x  , y   , l   , 1 , CMD_BUTTON_LIGHT_LINE);
    draw_block(x  , y   , 1   , h , CMD_BUTTON_LIGHT_LINE);
    draw_block(x        , y  fi_+ h , l  fi_+ 1 , 1 ,CMD_BUTTON_DARK_LINE );
    draw_block(x  fi_+ l, y         , 1         , h ,CMD_BUTTON_DARK_LINE);
    light_area(x fi_+1,y fi_+1,h fi_-1,l fi_-1);
    if has_LED then
        draw_block(x fi_+50,y fi_+23,LED_WIDTH,LED_HEIGHT,CMD_BUTTON_DARK_LINE);
        draw_block(x fi_+50,y fi_+23,LED_WIDTH fi_-1,LED_HEIGHT fi_-1,LED_OFF);
    endif;
    if sensitive then
    	CMD_BUTTON_TEXT_COLOR -> XptValue(current_graphic_widget, XtN foreground);
    else
     	5 -> XptValue(current_graphic_widget, XtN foreground);
    endif;
   	XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^times_bold_12}]));
    XpwDrawString(current_graphic_widget,x  fi_+ 5,y  fi_+ 15 , s);
    XpwDrawString(current_graphic_widget,x  fi_+ 5,y  fi_+ 28 , t);
	;;; now to hatch out if on a mono system and button is inactive
	if not(isrgb) then
		if not(sensitive) then
			x fi_+2->x;
			CMD_BUTTON_WIDTH fi_- 6 -> h; ;;; I can use these now
     		fast_for i from 2 by 2 to (CMD_BUTTON_HEIGHT fi_-3) do
      			draw_block( x, y fi_+ i, h,1,0);
     		endfast_for;
		endif;
	endif;
   	XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^chrs_font}]));

enddefine;


define constant  draw_cmd_button_in(x,y,l,h,s,t,sensitive,has_LED);;/*
  LED       = LED indicator :boolean
  sensitive = responds to mouse
  s         = label for button :str
  t         = label for button :str
  l         = length of area to be drawn :int
  h         = depth  of  -:-      -:-    :int
  xy        = start xy -:-      -:-      :int
*/
    lvars x y l h s t sensitive has_LED ;
    draw_block(x  , y   , l   , 1 ,CMD_BUTTON_DARK_LINE );
    draw_block(x  , y   , 1   , h , CMD_BUTTON_DARK_LINE);
    draw_block(x  , y  fi_+ h , l  fi_+ 1 , 1 ,CMD_BUTTON_LIGHT_LINE );
    draw_block(x  fi_+ l, y   , 1   , h ,CMD_BUTTON_LIGHT_LINE );
    dark_area(x fi_+1,y fi_+1,h fi_-1,l fi_-1) ;
    if has_LED then
        draw_block(x fi_+50,y fi_+23,LED_WIDTH,LED_HEIGHT,CMD_BUTTON_DARK_LINE);
        draw_block(x fi_+50,y fi_+23,LED_WIDTH fi_-1,LED_HEIGHT fi_-1,LED_ON);
    endif;
    if sensitive then
    	CMD_BUTTON_TEXT_COLOR -> XptValue(current_graphic_widget, XtN foreground);
    else
     	5 -> XptValue(current_graphic_widget, XtN foreground);
    endif;
   	XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^times_bold_12}]));
    XpwDrawString(current_graphic_widget,x  fi_+ 5,y  fi_+ 15 , s);
    XpwDrawString(current_graphic_widget,x  fi_+ 5,y  fi_+ 28 , t);
   	XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^chrs_font}]));

enddefine;



/* draws the button on the screen according to its attributes */
define constant set_button(extract,state);/*
  state   = button in or out :int
  extract = handle to reference the button :proc
*/
    lvars extract,state,
        x,y,
        color,
        shape,sensitive,
        string1,string2,string3,
        has_LED ;
    lconstant in_set = 8 ; ;;; inset from left edge for text position
    extract.button_x_pos -> x;
    extract.button_y_pos -> y;
    extract.button_colour-> color;
    extract.button_shape -> shape;
    extract.button_sensitive -> sensitive;
    extract.button_string1->string1;
    extract.button_string2->string2;
    extract.button_string3->string3;
    extract.button_has_led->has_LED;
   	XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^times_bold_12}]));
	if shape == CHUNKY then
		;;; create blank button images
        XpwCopyFrom(image_out_wr,image_out_ro, 0,0,
            CHUNKY_BUTTON_WIDTH, CHUNKY_BUTTON_HEIGHT,
            0,0);
        XpwCopyFrom(image_in_wr,
            image_in_ro,
            0,
            0,
            CHUNKY_BUTTON_WIDTH,
            CHUNKY_BUTTON_HEIGHT,
            0,
            0);
        ;;; put the text on the button images
        if state == OUT then
			if string1 = 'usesHelpButton' then
            	XpwCopyFrom(current_graphic_widget,
                	image_help_out, 0,0,
                	CHUNKY_BUTTON_WIDTH fi_+1,
                	CHUNKY_BUTTON_HEIGHT,
                	x fi_-2,y fi_+1);
			else
            	XtVaSetValues(image_out_wr,XptVaArgList([{font ^times_bold_12}]));
            	color->XptValue(image_out_wr, XtN foreground);
            	XpwDrawString(image_out_wr,
                	in_set,
                	round(CHUNKY_BUTTON_HEIGHT/4),
                	string1);
            	XpwDrawString(image_out_wr,
                	in_set,
                	round(CHUNKY_BUTTON_HEIGHT/2),
                	string2);
           		XpwDrawString(image_out_wr,
                	in_set,
                	round(CHUNKY_BUTTON_HEIGHT/1.33),
                	string3);
            	XpwCopyFrom(current_graphic_widget,
                	image_out_wr, 0,0,
                	CHUNKY_BUTTON_WIDTH,
                	CHUNKY_BUTTON_HEIGHT,
                	x fi_-2,y fi_+1);
			endif;
			;;; if the button has an LED indicator switch it off
            if has_LED then
               	draw_block(x fi_+60,y fi_+65,LED_WIDTH,LED_HEIGHT,1);
                draw_block(x fi_+60,
                    y fi_+65,
                    LED_WIDTH fi_-1,
                    LED_HEIGHT fi_-1,
                    LED_OFF);
			else
				if isrgb then
               		draw_block(x fi_+60,y fi_+65,LED_WIDTH,LED_HEIGHT,1);
                	draw_block(x fi_+60,
                    	y fi_+65,
                    	LED_WIDTH fi_-1,
                    	LED_HEIGHT fi_-1,
                    	RED_LED_OFF);
				endif;
            endif;
        elseif state == IN then
            XtVaSetValues(image_in_wr,XptVaArgList([{font ^times_bold_12}]));
            color->XptValue(image_in_wr, XtN foreground);
			if string1 = 'usesHelpButton' then
            	XpwCopyFrom(current_graphic_widget,
                	image_help_in, 0,0,
                	CHUNKY_BUTTON_WIDTH fi_+1,
                	CHUNKY_BUTTON_HEIGHT,
                	x fi_-2,y fi_+1);
			else
            	XpwDrawString(image_in_wr,
                	in_set,
                	round(CHUNKY_BUTTON_HEIGHT/4)
                	,string1);
            	XpwDrawString(image_in_wr,
                	in_set,
                	round(CHUNKY_BUTTON_HEIGHT/2),
                	string2);
           		XpwDrawString(image_in_wr,
                	in_set,
                	round(CHUNKY_BUTTON_HEIGHT/1.33),
                	string3);
            	XpwCopyFrom(current_graphic_widget,
                	image_in_wr,
                	0,0,
                	CHUNKY_BUTTON_WIDTH,
                	CHUNKY_BUTTON_HEIGHT,
                	x fi_-2,y fi_+1);
			endif;
            ;;; if the button has an LED indicator switch it on
            if has_LED then
                draw_block(x fi_+60,
                    y fi_+65,
                    LED_WIDTH,
                    LED_HEIGHT,
                    1);
               	draw_block(x fi_+60,y fi_+65,LED_WIDTH,LED_HEIGHT,1);
                draw_block(x fi_+60,
                    y fi_+65,
                    LED_WIDTH fi_-1,
                    LED_HEIGHT fi_-1,
                    LED_ON);
			else
				if isrgb then
                	draw_block(x fi_+60,
                    	y fi_+65,
                    	LED_WIDTH,
                    	LED_HEIGHT,
                    	1);
               		draw_block(x fi_+60,y fi_+65,LED_WIDTH,LED_HEIGHT,1);
                	draw_block(x fi_+60,
                    	y fi_+65,
                    	LED_WIDTH fi_-1,
                    	LED_HEIGHT fi_-1,
                    	RED_LED_ON);
				endif;
            endif;
        endif;
    elseif shape == CMD then
        if state == OUT then
            draw_cmd_button_out(x,
                y,
                CMD_BUTTON_WIDTH,
                CMD_BUTTON_HEIGHT,
                string1,
                string2,
                sensitive,
                has_LED);
        elseif state == IN   then
            draw_cmd_button_in(x,
                y,
                CMD_BUTTON_WIDTH,
                CMD_BUTTON_HEIGHT,
                string1,
                string2,
                sensitive,
                has_LED);
    	elseif shape == RECT then
        	if state == OUT then
            	draw_cmd_button_out(x,
                	y,
                	CMD_BUTTON_WIDTH,
                	CMD_BUTTON_HEIGHT,
                	string1,
                	string2,
                	sensitive,
                	has_LED);
        	elseif state == IN   then
            	draw_cmd_button_in(x,
                	y,
                	CMD_BUTTON_WIDTH,
                	CMD_BUTTON_HEIGHT,
                	string1,
                	string2,
                	sensitive,
                	has_LED);
        	else
            	mishap('Unknown mode');
        	endif;
    	else
        	mishap('Unknown button type');
    	endif;
	endif;
   	XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^chrs_font}]));

enddefine;


define constant sensitise( button, mode);
/*
  button = button id : word
  mode  =  in or out : int
	*/
	lvars button, mode, ex;
   	XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^times_bold_12}]));
	button_table(button) -> ex;
	mode-> ex.button_sensitive;
	set_button(ex,OUT);
   	XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^chrs_font}]));

enddefine;


/* toggles the state of button id */

define constant xor_state( id ); /*
id = id of the button to be toggled : word */
    lvars id
        extract
        button_toggled=false;
	if id then
    	button_table( id ) -> extract;
    	if extract.button_sensitive then
    		extract.button_state ||/& 1 -> extract.button_state;
    		if extract.button_state == IN then
        		set_button(extract,IN);
        		true -> button_toggled;
                ;;; prevents the button from being retoggled
    		endif;
    		if button_toggled then
    			;;; do nothing
    		elseif extract.button_state == OUT  then
        		set_button(extract,OUT);
    		endif;
   		else
   			;;; button is not sensitive
   		endif;
	endif;

enddefine;

/* creates a record of which button pages have been accessed  */
/* and in what order so that clicking on the background will */
/* unwind to the previous level

NB       it dumps an item on the stack*/

define constant  stack();
	::DEMO_PATH->DEMO_PATH;
enddefine;


/*  puts some decoration of the window */

define constant decorate_window(menu_bar);
	lvars menu_bar title_x;

	if current_demotool_widget == demotool_widget2 then
 		move_image(0,0,viewport_width,CMD_BUTTON_HEIGHT fi_+1,'',OUT);
	else
 		move_image(0,0,WINDOW_WIDTH,CMD_BUTTON_HEIGHT fi_+1,'',OUT);
	endif;

enddefine;



/* sets the current page of buttons and also change the specific help
file associated with the INFORMATION button top left of screen        */

define constant activate( buttons, owner ); /*
  owner   = parent of the buttons :widget POPLOG graphic
buttons = buttons to present to the user :list */
    lvars buttons owner button extract tmp_list;
	;;; assumes those buttons which do not require the
	;;; screen to be cleared are defined and are recorded
	;;; in the list, buttons_to_overlay

	false->last_cmd_button_selected;
	false->last_chunky_button_selected;
    buttons_to_overlay -> tmp_list;
    if (buttons == level_menu_bar_buttons) then
    	;;; do nothing because the important bit is
    else
        clear_area(0,0, WINDOW_WIDTH , WINDOW_HEIGHT);
       	decorate_window(true);
        true->button_table("demo_up").button_sensitive;
        if buttons = level_one_buttons then
 			;;;           false->button_table("demo_up").button_sensitive;
            about_the_tool -> about_the_pds;
        elseif buttons =level_intro_buttons then
            about_the_tool -> about_the_pds;
            false->button_table("demo_info").button_sensitive;
        elseif buttons =level_intro_index_buttons then
            about_intro_to_poplog -> about_the_pds;
        elseif buttons =level_two_buttons then
            about_the_apps -> about_the_pds;
        elseif buttons =level_four_buttons then
            about_the_products -> about_the_pds;
        elseif buttons = level_six_buttons then
            about_the_sourcelibs -> about_the_pds;
        endif;
    endif;
    active_level_buttons -> last_active_level;
    buttons -> active_level_buttons;
    fast_for button in buttons do
        button_table(hd(buttons)) -> extract;
        tl(buttons)->buttons;
        OUT->extract.button_state;
        owner->extract.button_owner;
		;;; here
        set_button(extract,extract.button_state);
    endfast_for;
	;;; its a new page and so no buttons selected....
	false->last_cmd_button_selected;
	false->last_chunky_button_selected;

enddefine;


/* check whether or not a mouse button has been pressed with the */
/* pointer over a button and if so, return the button pressed    */

define constant procedure check_x_y( mouse_x,mouse_y );
    lvars mouse_x,
        mouse_y,
        x,
        y,
        button,
        button_width,
        button_height,
        extract,
        shape,
        pressed_button = false,
        buttons = active_level_buttons;

    fast_for button in buttons do
        if not(pressed_button) then
        	button_table(hd(buttons)) -> extract;
        	extract.button_x_pos -> x;
        	extract.button_y_pos -> y;
        	extract.button_shape -> shape;
       		;;; target zone differs depending on button shape
        	if shape == CHUNKY then
            	CHUNKY_BUTTON_WIDTH -> button_width;
            	CHUNKY_BUTTON_HEIGHT -> button_height;
        	elseif shape == CMD then
            	CMD_BUTTON_WIDTH -> button_width;
            	CMD_BUTTON_HEIGHT -> button_height;
        	elseif shape == RECT then
            	CMD_BUTTON_WIDTH -> button_width;
            	CMD_BUTTON_HEIGHT -> button_height;
        	else
            	mishap('Invalid button type');
        	endif;
			;;; if pointer is over a buton, return the button id
        	if mouse_x fi_> x and mouse_x fi_< x fi_+ button_width then
            	if mouse_y fi_> y and mouse_y fi_< y fi_+ button_height then
              		button -> pressed_button;
				endif;
        	endif;
        	tl(buttons)->buttons;
     	else
     		return(pressed_button);
        endif;   ;;; if not(button_pressed)
    endfast_for;
    return(pressed_button);

enddefine;



/* used to change the active page of buttons and keep a record of which */
/* pages have been accessed and in what order                           */

define constant display( buttons );/*
  buttons = buttons to present to the user :list
*/
	lvars buttons;
	;;; test jdp
    false->last_cmd_button_selected;
    false->>button_selected -> button_on_which_mouse_pressed;
	activate( buttons, current_graphic_widget );
	stack( last_active_level);

enddefine;


define  constant procedure timeout_callback(a, b);
	/* future development */
    lvars a,b;
    true -> had_input;

enddefine;




define constant check_installed_demos();
	if arbs_slides /= [] then
		true->button_table("arbs_demo").button_has_led;
	endif;
	if excap_slides /= [] then
		true->button_table("excap_demo").button_has_led;
	endif;
	if faust_slides /= [] then
		true->button_table("faust_demo").button_has_led;
	endif;
	if ive_slides /= [] then
		true->button_table("ive_demo").button_has_led;
	endif;
	if sat_slides /= [] then
		true->button_table("sat_demo").button_has_led;
	endif;
	if tasker_slides /= [] then
		true->button_table("tasker_demo").button_has_led;
	endif;
	if walker_slides /= [] then
		true->button_table("walker_demo").button_has_led;
	endif;
	if xmed_slides /= [] then
		true->button_table("head_demo").button_has_led;
	endif;

enddefine;



/******************** end of button control routines ********************/



/********************** procedures to create pixmaps ********************/


define constant copy_rasterfile(image_file, parent_widget, image_name);/*

image_file,    name of file containing raster image : string
parent_widget, :widget
image_name     the variable by which the image may be referenced
*/

	;;; create the pixmap, read in the raster & returns the image name on the stack

	lvars image_file, parent_widget, image_name;

    demotool_rasterfile(image_file)->arr;
    XtCreateWidget('raster image', XpwPixmap, parent_widget,
        XptArgList([
                [^XtN width  ^ras_width ]
                [^XtN height ^ras_height ]
            ]))
        -> image_name;

    XpwDrawImage(image_name,
        ras_width, ras_height,
        0,0 ,
        arr);

	image_name;


enddefine;



define  constant procedure create_button_pixmaps();

    copy_rasterfile('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/isl_logo_in.rs' ,
        demotool_widget , image_isl_logo )->image_isl_logo;
    copy_rasterfile('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/help_button_out.rs',
        demotool_widget, image_help_out)->image_help_out;
    copy_rasterfile('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/help_button_in.rs',
        demotool_widget, image_help_in)->image_help_in;
    copy_rasterfile('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/chunky_button_out.rs' ,
        demotool_widget ,image_out_wr)->image_out_wr;
	;;; make a copy of it
   	XtCreateWidget('button' , XpwPixmap, demotool_widget,
        XptArgList([[^XtN width ^ras_width][^XtN height ^ras_height]])) -> image_out_ro;
    XpwCopyFrom(image_out_ro, image_out_wr,0,0, ras_width,ras_height, 0,0);
    copy_rasterfile('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/chunky_button_in.rs' ,
        demotool_widget ,image_in_wr)->image_in_wr;
	;;; make a copy of it
    XtCreateWidget('button' , XpwPixmap, demotool_widget,
        XptArgList([[^XtN width ^ras_width][^XtN height ^ras_height]])) -> image_in_ro;
    XpwCopyFrom(image_in_ro, image_in_wr, 0,0, ras_width, ras_height, 0,0);

enddefine;


define  constant procedure create_misc_pixmaps();

	copy_rasterfile('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/poplog14.rs',
        demotool_widget,banner_img) -> banner_img;
	copy_rasterfile('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/machine.rs',
        demotool_widget,machines_img) -> machines_img;
	copy_rasterfile('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/mb1.rs',
        demotool_widget,mb1_img) -> mb1_img;
	copy_rasterfile('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/mb2.rs',
        demotool_widget,mb2_img)-> mb2_img;
	copy_rasterfile('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/mb3.rs',
      	demotool_widget,mb3_img) -> mb3_img;
    XtCreateWidget('mb0' , XpwPixmap, demotool_widget,
        XptArgList([[^XtN width ^ras_width][^XtN height ^ras_height]])) -> mb0_img;

enddefine;



define  constant procedure initialise_demotool_pixmaps();
	create_misc_pixmaps();
	create_button_pixmaps();

enddefine;


/**************** end of pixmap related routines ******************/





/****************************************************************
        procedures to make the various shells
*****************************************************************/
vars iconwindow;

define  constant procedure mkdemotool_shell();
	#_IF DEF XMOTIF
	dlocal XptWMProtocols = false;
	#_ENDIF

	#_IF XOPENLOOK
	xved_create_icon_window('$usepop/pop/x/ui/demo/src/images/popdemotool_64.xbm',false)->iconwindow;
	#_ENDIF

    XtAppCreateShell( 'Poplog Demotool (Version 1.1)  \(169)1992 ISL' , 'PoplogDemotoolmcp',
        ApplicationShell,
        XptDefaultDisplay,
		XptArgList([{x 250}{y 300}
                {iconWindow ^iconwindow}
				% #_IF DEF XMOTIF
        		{deleteResponse ^XmUNMAP}
				#_ENDIF %
				{borderWidth 10} ])) -> demotool_widget;
	false -> XptValue(demotool_widget, XtN allowShellResize,TYPESPEC(:XptBoolean));
    XtCreateManagedWidget('demotool_graphic',
        XpwGraphic,
        demotool_widget,
        XptArgList([
                {y 51}
                {width ^WINDOW_WIDTH}
                {height ^WINDOW_HEIGHT}

            ])) -> demotool_graphic;
    XtVaSetValues(demotool_graphic, XptVaArgList([{font ^times_bold_12}]));
	demotool_graphic->current_graphic_widget;
    XptAppTryEvents( XptCurrentAppContext );
enddefine;



vars iconwindow2;

define  constant procedure mkdemotool_shell2();
	#_IF DEF XMOTIF
	dlocal XptWMProtocols = false;
	#_ENDIF

	#_IF XOPENLOOK
	xved_create_icon_window('$usepop/pop/x/ui/demo/src/images/popdemotool_64.xbm',false)->iconwindow2;
	#_ENDIF

    XtAppCreateShell( 'Poplog Demotool (Version 1.1)  \(169)1992 ISL' , 'PoplogDemotoolmcp',
        ApplicationShell,
        XptDefaultDisplay, XptArgList([{x 100}{y 0}
                {iconWindow ^iconwindow2}
				{min_aspect_width ^viewport_width}
				{min_width ^viewport_width}
				{min_aspect_height ^viewport_height}
				{min_height ^viewport_height}
				% #_IF DEF XMOTIF
        		{deleteResponse ^XmDO_NOTHING}
				#_ENDIF %

				{borderWidth 10} ])) -> demotool_widget2;
    XtCreateManagedWidget('demotool_graphic',
        XpwGraphic,
        demotool_widget2,
        XptArgList([
                [^XtN y 51]
                [^XtN width ^viewport_width]
                [^XtN height ^(viewport_height+5)]
            ])) -> demotool_graphic2;
    XtVaSetValues(demotool_graphic2, XptVaArgList([{font ^times_bold_12}]));
	demotool_graphic2->current_graphic_widget;
    XptAppTryEvents( XptCurrentAppContext );

enddefine;


define  constant procedure mksummary_shell();
	#_IF DEF XMOTIF
	dlocal XptWMProtocols = false;
	#_ENDIF

    XtAppCreateShell( 'summary' , 'PoplogDemotoolsummary',
        XptWidgetSet("ToolKit")("TransientShellWidget"),
        XptDefaultDisplay, XptArgList([{x 250}{y 300}
				% #_IF DEF XMOTIF
        		{deleteResponse ^XmDO_NOTHING}
				#_ENDIF %
			])) -> summary_widget;
    XtCreateManagedWidget('demotool_graphic',
        XpwGraphic,
        summary_widget,
        XptArgList([
                [^XtN width ^WINDOW_WIDTH]
                [^XtN height 110]

            ])) -> summary_graphic;
    XptAppTryEvents( XptCurrentAppContext );


enddefine;



vars tmp_arr;

define constant mkdemotool();
   	false -> last_button_selected;
    mkdemotool_shell();
    mkdemotool_shell2();
    mksummary_shell();
    demotool_graphic -> current_graphic_widget;
    XtVaSetValues(demotool_graphic, XptVaArgList([{font ^times_bold_12}]));
    XtRealizeWidget(summary_widget);
    XtRealizeWidget(demotool_widget);
	XtDisplay(demotool_widget)-> demotool_widget_display;
	XtWindow(demotool_widget)-> demotool_widget_window;
	XtDisplay(summary_widget)-> summary_widget_display;
	XtWindow(summary_widget)-> summary_widget_window;
    demotool_widget->current_demotool_widget;
   	initialise_demotool_pixmaps();
   	initial_display(); ;;;this is the banner
   	initialise_buttons();
	if isrgb then
		;;; motif version currently has problems addressing cmap
		;;; so

		if isrgb then
			get_def_cmap(demotool_graphic);

    		demotool_graphic->current_graphic_widget;
    		XpwCreateColormap(demotool_graphic );
    		XpwAllocColor(demotool_graphic, 1,1,1) ->text_color;
   			text_color or 0 -> text_color;
			#_IF DEF IRIS
    		XpwAllocColorRange(demotool_graphic, 255, 0,0,0, 255,255,255)->demotool_graphic_cmap;
			#_ELSE
    		XpwAllocColorRange(demotool_graphic, 254, 0,0,0, 255,255,255)->demotool_graphic_cmap;
			#_ENDIF
    		fast_for i in def_basic_colors do
        		XpwChangeColor(demotool_graphic, explode(i));
    		endfast_for;
			motif_openwin_cmap(demotool_graphic);

 		endif;
    	;;;set_colormap(); ;;; perhaps this should ONLY be done once jdp
		;;;    cmap_entry_rgb(CMD_BUTTON_TEXT_COLOR,255,255,0);
		;;; 20 may be incorrect jdp
		if CMD_BUTTON_IN_COLOR  fi_> 20 then
			cmap_entry_rgb(CMD_BUTTON_IN_COLOR , 190,190,190);
			cmap_entry_rgb(CMD_BUTTON_OUT_COLOR, 230,230,230);
    		;;; allows to redefine the colour of cmd buttons, or set
    		;;; them to be the same as the chunky buttons
    	endif;
    	XpwChangeColor(current_graphic_widget,  LED_OFF , 0, 170, 0);
    	XpwChangeColor(current_graphic_widget,  LED_ON, 140, 255, 140);
    	XpwChangeColor(current_graphic_widget,  RED_LED_OFF ,200,0,0);
    	XpwChangeColor(current_graphic_widget,  RED_LED_ON, 255,90,90);
	endif;

	CMD_BUTTON_TEXT_COLOR->XptValue(demotool_graphic,XtN foreground);
    XtVaSetValues(demotool_graphic, XptVaArgList([{font ^times_bold_12}]));
    XpwDrawString(demotool_graphic,
        200,CMD_BUTTON_VERTICAL,
        'LOADING THE DEMO SYSTEM .....');
	move_image(405,CMD_BUTTON_VERTICAL,90,26,'',OUT); amount_to_load(1);
	;;; since we are entering the demo system there was no last active level
    false -> last_active_level;                    amount_to_load(2);
    amount_to_load(3);
    amount_to_load(4);
    amount_to_load(5);
    amount_to_load(6);
    check_installed_demos();
    amount_to_load(7);
    amount_to_load(8);
    ;;; remove the message......
    BGC->XptValue(demotool_graphic,XtN foreground);
    XtVaSetValues(demotool_graphic, XptVaArgList([{font ^times_bold_12}]));
    amount_to_load(9);
    amount_to_load(10);
    XpwDrawString(demotool_graphic,
        200,CMD_BUTTON_VERTICAL,
        'LOADING THE DEMO SYSTEM .....'); amount_to_load(10);
    false -> intro_tool_active ;
    XtAddCallback( demotool_graphic,
        XtN buttonEvent,
        demotool_mb_cb,
        "clicked");
    XtAddCallback( demotool_graphic2,
        XtN buttonEvent,
        demotool_mb_cb,
        "clicked");
    exacc (2) raw_XUnmapWindow(summary_widget_display,
        summary_widget_window);
    XptAppAddActionList(XptDefaultAppContext,
        [['XptWmProtocol' ^exit_action]]);

enddefine;



/********************** end of shell making procs ******************/




/********* procedures to display text and or images **************/


define put_page_No_of();
	if isinteger(p_mark_x) and isinteger(p_mark_y) then
		' page 'sys_>< current_position sys_>< ' of ' sys_>< length(subject_list) -> msg;
   		XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^times_bold_12}]));
		XpwDrawString(current_graphic_widget, p_mark_x,p_mark_y, msg);
   		XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^chrs_font }]));
    endif;

enddefine;

define  constant procedure display_text( xorigin,yorigin,n,graphic);
/*
 xorigin,xorigin = offset at which to print
 n = name of the file containing ascii text
graphic = graphic widget upon which to draw text
	*/
	;;; put up associated text messages
	lvars xorigin yorigin  n graphic dev getline line vstep temp ;

	current_graphic_widget -> temp; ;;; keep a record of where we were
	if not(xorigin) then
    	10->xorigin;
	endif;
	if not(yorigin) then
		65->yorigin;
	endif;
    if demotool_size = RUNDEMO then
    	clear_area(xorigin fi_-2,yorigin,xorigin fi_+ 457,yorigin fi_+ 450);
    elseif demotool_size = SLIDESHOW then
    	move_image(0,656,998,212,'',OUT);
    else
    	mishap(0,'DEMOTOOL: unknown value for demotool_size');
    endif;
    XtVaSetValues(current_graphic_widget, XptVaArgList([{font ^chrs_font}]));
    CMD_BUTTON_TEXT_COLOR-> XptValue(current_graphic_widget, XtN foreground);
    18 -> vstep;
	if not(isstring(n)) then
        '$usepop/pop/x/ui/demo/src/text/default.text'->n;
    endif;

	if readable(n) then

    	sysopen( n, 0, "line") -> dev;
    	line_repeater(dev, 1000) -> getline; ;;; this sometimes fails to open file jdp
    	fast_repeat;
        	getline() -> line;
    	quitif(line == termin);
        	XpwDrawString(current_graphic_widget,xorigin, yorigin, line);
        	yorigin fi_+ vstep -> yorigin;
    	endfast_repeat;
    	sysclose(dev);
		temp->current_graphic_widget;
		put_page_No_of();
	endif;

enddefine;

vars first_time_prompt_response=true;

define  constant procedure prompt_response(x,y,valid_mouse_button);
/*
x,y = x y coords at which to display the image of hand and mouse
image determined by valid_mouse_button

latter currently not used

	*/
    lvars x,y, valid_mouse_button image_to_use;
    lvars timer_id = false, wait_until_valid = false,img_ras_height,img_ras_width;

	if first_time_prompt_response then
		false->first_time_prompt_response;
    	rasterfile_info('$usepop/pop/x/ui/demo/src/images/' sys_><screenType sys_>< '/mb1.rs');
		ras_width  -> img_ras_width ;
		ras_height -> img_ras_height ;
	endif;

	if valid_mouse_button fi_>10 then
		true->wait_until_valid;
		valid_mouse_button fi_- 10-> valid_mouse_button;
	endif;

	;;; jdp 20/4/92    XpwCopyFrom(demotool_graphic,mb1_img,0,0,img_ras_width,img_ras_height,x,y);
    XpwCopyFrom(demotool_graphic,mb1_img,0,0,48,90,x,y);

    false ->> had_input -> requested_to_stop;
    false -> the_button_clicked_on;

enddefine;


define constant  procedure display_text_and_wait(file,posn,button);
/*
 file   = ascii file to be displayed
 posn   = at position see below
 button = mouse button which causes procedure to exit

	*/
  	lvars file,posn,button,x,y;

    switchon posn
    case = TOP_LEFT then
        5->> x ->y;
    case = BOTTOM_LEFT then
        5->x;
        XptValue(current_graphic_widget,XtN height,"short")fi_-90->y;
    case = BOTTOM_RIGHT then
        XptValue(current_graphic_widget,XtN width,"short")fi_-60->x;
        XptValue(current_graphic_widget,XtN height,"short")fi_-90->y;
    case = TOP_RIGHT then
        XptValue(current_graphic_widget,XtN width,"short")fi_-60->x;
        5->y;
    endswitchon;
    ;;; in the current graphic widget
    false->>had_input->the_button_clicked_on;
	if file then
    	display_text(false,false,file,current_graphic_widget);
	endif;
    prompt_response(x,y,button);
    the_button_clicked_on == button;

enddefine;



define  constant display_using( slide );
    lvars slide;

	if  slide_holder(slide).image /=  slide_holder("temp_store").image then
        load_image(slide_holder(slide).image);
	endif;
	if  slide_holder(slide).proc  /=  slide_holder("temp_store").proc then
		apply(slide_holder(slide).proc);
	endif;
    if  slide_holder(slide).text /= slide_holder("temp_store").text then
        move_image(0,656,998,212,'',OUT);
		display_text(10,657, slide_holder(slide).text , current_graphic_widget);
    endif;
    slide_holder(slide).text  -> slide_holder("temp_store").text;
    slide_holder(slide).image -> slide_holder("temp_store").image;
    slide_holder(slide).proc  -> slide_holder("temp_store").proc;
 	put_page_No_of();

enddefine;


define  constant display_text_image(xorigin, yorigin, p_markx, p_marky, x, y, list );
    lvars xorigin,yorigin,p_markx,p_marky,x,y,list;
    lconstant INDEX = 1;
    lvars current_position = 1,
     	requested_to_stop = false,
     	extract,
	 	min_lim = true, max_lim = true,
     	first_time_in = true,
     	the_intro_next_button_locked = true,
     	the_intro_previous_button_locked = true,
	 	msg = '',
		;

   	list->subject_list ;
   	length(subject_list)->list_length ;
    p_markx->p_mark_x; p_marky->p_mark_y;
    sensitise("intro_previous",false);
    sensitise("intro_restore",false);
	sensitise("intro_save",false);
	sensitise("intro_next", true);
	if not(x) then
		;;;    XptValue(current_graphic_widget,XtN width,"short")fi_-60->x;
		445->x;
	endif;
	if not(y) then
    	XptValue(current_graphic_widget,XtN height,"short")fi_-85->y;
	endif;
	if current_position fi_>1 then
  		false -> the_intro_previous_button_locked;
	endif;
	if button_table("intro_next").button_sensitive then
  		false->the_intro_next_button_locked;
	endif;

    if current_position <= length(list) then
       	display_using(subject_list( current_position));
    endif;

enddefine;


define constant  display_intro_text(x_origin, y_origin, p_mark_x, p_mark_y, x, y, list );
    lvars x_origin,y_origin,p_mark_x, p_mark_y,p_markx,p_marky,x,y,list ; /*subject_list;

    x_origin,y_origin,   - start position for text
    p_markx,p_marky,   - position of the page n of N string
    x,y,                 - position of the mouse and finger image
    list                 - list of files to be displayed
	*/
    lconstant INDEX = 1;
    lvars msg = '';
    lvars  extract;
    lvars first_time_in = true;

    list -> subject_list;
	x_origin -> xorigin;
	y_origin -> yorigin;
    sensitise("intro_previous",false);

	if length(list)>1 then
        sensitise("intro_next", true);
    else
        sensitise("intro_next", false);
    endif;

	if not(x) then
		;;;    XptValue(current_graphic_widget,XtN width,"short")fi_-60->x;
		445->x;
	endif;
	if not(y) then
    	XptValue(current_graphic_widget,XtN height,"short")fi_-85->y;
	endif;

    if current_position <= length(list) then
      	if readable(subject_list( current_position)) then
        	display_text(xorigin,yorigin, subject_list( current_position), demotool_graphic);
        	put_page_No_of();
      	endif;
    endif;

enddefine;


/* show projector displays the screen dunps and text for the slide show */

define  constant show_projector(list_of_slides);
	lvars list_of_slides;

	;;; the motif version does not display rgb images of the applications
	;;; so instruct to pick up mono images irrespectve of screen deph if motif
/*	#_IF XMOTIF

	'/MONO'->screenType;

	#_ENDIF
	*/
	if list_of_slides = [] then
		pop_ui_message('  The demo you selected has not been installed  \n\n Consult your POPLOG Administrator. ',true,false);
	else
		set_demotool_size(SLIDESHOW);
    	'no text' -> slide_holder("temp_store").text;
    	'no image' -> slide_holder("temp_store").image;
    	identfn -> slide_holder("temp_store").proc;
    	exacc (2) raw_XUnmapWindow(demotool_widget2_display,
        	demotool_widget2_window);
    	false->last_cmd_button_selected;
    	false->>button_selected -> button_on_which_mouse_pressed;
    	draw_block(0,0,viewport_width,viewport_height+100,BGC2);
    	928->button_table("demo_exit").button_x_pos;
    	move_image(0,656,998,212,'',OUT);
    	move_image(887,39,112,614,'',OUT);
    	true-> button_table("demo_exit").button_sensitive;
    	activate(level_intro_buttons,current_graphic_widget);
    	draw_block(0,39,WINDOW_WIDTH,4,BGC2);
    	move_image(1,39,885,614,'' ,OUT);
    	font18->chrs_font;
    	XtVaSetValues(current_graphic_widget,
    		XptVaArgList([{font ^chrs_font }]));
		;;; because we have two type of image,
    	;;; switch on the mechanism to determin which to load.
    	true -> image_has_mono_and_rgb;
    	exacc (2) raw_XMapWindow(demotool_widget2_display,
        	demotool_widget2_window);
    	exacc (2) raw_XUnmapWindow(demotool_widget_display,
        	demotool_widget_window);
		1->current_position;
   		demotool_sensitive(true);
   		display_text_image(false,600,905,690,
    		viewport_width-55,viewport_height-90,list_of_slides);
	endif;

enddefine;


/* show a summary file displays a file associated with each of the */
/* application buttons when they are pressed */

define  constant show_a_summary_file(n);
  	lvars n xorigin yorigin dev line vstep getline;

    exacc (4) raw_XMoveWindow( summary_widget_display,
        summary_widget_window,
        (XptValue(demotool_widget,XtN x, TYPESPEC(:XptShort)) fi_+9),
        ( XptValue(demotool_widget,XtN y,"short")  fi_+ WINDOW_HEIGHT fi_+17));
    exacc (2) raw_XRaiseWindow( summary_widget_display,
        summary_widget_window);
	10->xorigin;
	20->yorigin;
	summary_graphic->current_graphic_widget;
	move_image(0,0,WINDOW_WIDTH-1,109,'',IN);
	move_image(5,5,WINDOW_WIDTH-12,99,'',OUT);
    exacc (2) raw_XMapWindow(summary_widget_display,summary_widget_window);
    exacc (4) raw_XMoveWindow( summary_widget_display,
        summary_widget_window,
        (XptValue(demotool_widget,XtN x, TYPESPEC(:XptShort)) fi_+9),
        ( XptValue(demotool_widget,XtN y,TYPESPEC(:XptShort)) fi_+ WINDOW_HEIGHT fi_+17));
    XtVaSetValues(summary_graphic, XptVaArgList([{font ^chrs_font}]));
    CMD_BUTTON_TEXT_COLOR-> XptValue(summary_graphic, XtN foreground);
    15 -> vstep;
    if not(isstring(n)) then
        '$usepop/pop/x/ui/demo/descriptions/default.desc'->n;
    endif;
    sysopen( n, 0, "line") -> dev;
    line_repeater(dev, 1000) -> getline;
	;;; this sometimes fails to open file jdp
    fast_repeat;
        getline() -> line;
    quitif(line == termin);
        XpwDrawString(summary_graphic,xorigin, yorigin, line);
        yorigin fi_+ vstep -> yorigin;
    endfast_repeat;
    sysclose(dev);

enddefine;




/******************** end of display text or image routines ****************/


define constant set_intro_tool_buttons_x_pos(x);
	lvars x;
    x->>button_table("intro_next").button_x_pos
   		->button_table("intro_previous").button_x_pos;
	x->>button_table("intro_restore").button_x_pos
		->button_table("intro_save").button_x_pos;

enddefine;


define constant set_demotool_size(n);
    lvars n, i;

    if n = SLIDESHOW then
    	exacc (2) raw_XUnmapWindow(summary_widget_display,summary_widget_window);

		if  first_time_requested_to_swop  then
			XtRealizeWidget(demotool_widget2);
			XtDisplay(demotool_widget2)-> demotool_widget2_display;
			XtWindow(demotool_widget2)-> demotool_widget2_window;
        	exacc (2) raw_XUnmapWindow(demotool_widget2_display,
				demotool_widget2_window);
			false->first_time_requested_to_swop;

			if isrgb then
    			demotool_graphic2->current_graphic_widget;
    			XpwCreateColormap(demotool_graphic2 );
    			XpwAllocColor(demotool_graphic2, 1,1,1) ->text_color;
   				text_color or 0 -> text_color;

				#_IF DEF IRIS
    			XpwAllocColorRange(demotool_graphic2, 255, 0,0,0, 255,255,255)->demotool_graphic_cmap2;
				#_ELSE
    			XpwAllocColorRange(demotool_graphic2, 254, 0,0,0, 255,255,255)->demotool_graphic_cmap2;
				#_ENDIF
    			fast_for i in def_basic_colors do
        			XpwChangeColor(demotool_graphic2, explode(i));
    			endfast_for;
    			;;;set_colormap(); ;;; perhaps this should ONLY be done once jdp

				motif_openwin_cmap(demotool_graphic2);

				;;;    cmap_entry_rgb(CMD_BUTTON_TEXT_COLOR,255,255,0);
				;;; 20 may be incorrect jdp
				if CMD_BUTTON_IN_COLOR  fi_> 20 then
					cmap_entry_rgb(CMD_BUTTON_IN_COLOR , 190,190,190);
					cmap_entry_rgb(CMD_BUTTON_OUT_COLOR, 230,230,230);
    				;;; allows to redefine the colour of cmd buttons, or set
    				;;; them to be the same as the chunky buttons
    			endif;
    			XpwChangeColor(current_graphic_widget,  LED_OFF , 0, 170, 0);
    			XpwChangeColor(current_graphic_widget,  LED_ON, 140, 255, 140);
    	 		XpwChangeColor(current_graphic_widget,  RED_LED_OFF ,200,0,0);
    	 		XpwChangeColor(current_graphic_widget,  RED_LED_ON, 255,90,90);
			endif;



		endif;
        demotool_graphic2->current_graphic_widget;
        demotool_widget2->current_demotool_widget;
		set_intro_tool_buttons_x_pos(910);
        false->button_table("demo_info").button_sensitive;
        decorate_window(true);
        true->SLIDESHOW_HAS_BEEN_SEEN;
    elseif n = RUNDEMO then
    	exacc (2) raw_XMapWindow(summary_widget_display,summary_widget_window);

        demotool_graphic->current_graphic_widget;
        demotool_widget->current_demotool_widget;
		set_intro_tool_buttons_x_pos(502);
        true->button_table("demo_info").button_sensitive;
        exacc (2) raw_XMapWindow(demotool_widget_display,
            demotool_widget_window);
        exacc (2) raw_XUnmapWindow(demotool_widget2_display,
            demotool_widget2_window);
    else
    	mishap(0,'DEMOTOOL: invalid window size');
    endif;
   	n -> demotool_size;

enddefine;



vars text_color;

/******************** pseudo call back routines ****************/



/******************* end of pseudo callback routines **********************/

define constant procedure display_one_line(single_line);
 	lvars single_line;
   	move_image(2,150,570,30,single_line,OUT);
    prompt_response(510,WINDOW_HEIGHT -90,1);
	false->release_lock;
    until release_lock do
        XtAppProcessEvent(XptDefaultAppContext ,XtIMAll );
    enduntil;

enddefine;

define lconstant procedure display_lines_of_text_in(f_name);
    lvars f_name,
        rep_dev,
        a_line_of_text,
        description = '',
        answer,
        ;
    false->release_lock;
    '$usepop/pop/x/ui/demo/descriptions/'sys_><f_name->f_name;
    line_repeater( f_name ,70)-> rep_dev;
    until ((rep_dev())->> a_line_of_text) = termin do;
        display_one_line(a_line_of_text);
    enduntil;


enddefine;


define constant procedure tutorial1(l);
    lvars l i j;/*future development */

    XtRemoveAllCallbacks( demotool_graphic,
        XtN buttonEvent);

    XtAddCallback( demotool_graphic,
        XtN buttonEvent,
        demotool_mb_cb2,
        "clicked");

    initial_display(); ;;; the poplog blue banner first seen
    decorate_window(true);
    activate( level_menu_bar_buttons,demotool_graphic);
    XtVaSetValues(demotool_graphic, XptVaArgList([{font ^times_bold_12}]));

    CMD_BUTTON_TEXT_COLOR->XptValue(demotool_graphic,XtN foreground);
    XtVaSetValues(demotool_graphic, XptVaArgList([{font ^times_bold_12}]));
    XpwDrawString(demotool_graphic,
        400,CMD_BUTTON_VERTICAL fi_+40,
        'Information viewed');
    move_image(405,CMD_BUTTON_VERTICAL,90,26,'',OUT); amount_to_load(0);

    display_one_line('The POPLOG DEMO SYSTEM consists of a number of "pages", each of which contain buttons. ');
    draw_cmd_button_out(180,CMD_BUTTON_VERTICAL,CMD_BUTTON_WIDTH,CMD_BUTTON_HEIGHT,'Information','',false,true);
    draw_cmd_button_out(90,CMD_BUTTON_VERTICAL,CMD_BUTTON_WIDTH,CMD_BUTTON_HEIGHT,'Another','button',false,true);
    set_button(button_table("ved_intro"),OUT);
 	amount_to_load( 1);
    set_button(button_table("im_intro"),OUT);
    CMD_BUTTON_TEXT_COLOR->XptValue(demotool_graphic,XtN foreground);
    draw_block(208 fi_+CMD_BUTTON_WIDTH,227,20,2,BLUE);
    draw_block(180 fi_+CMD_BUTTON_WIDTH,330,48,2,BLUE);
    XpwDrawString(demotool_graphic,300,333,'COMMAND');
    XpwDrawString(demotool_graphic,300,230,'TOPIC');
    display_one_line('There are two types of button which may be selected by pressing the indicated mouse button');
  	amount_to_load(2 );
   	display_one_line('               TOPIC buttons are about something,        COMMAND buttons do something,');
    display_one_line('A command button may only be pressed, AFTER a topic button has been selected');
  	amount_to_load( 3);
   	display_one_line('the topic button remains "selected" until another topic button has been pressed or ...');
    display_one_line('another page of buttons has been  presented. ');
    draw_block(200 fi_+CMD_BUTTON_WIDTH,270,25,2,BLUE);
    XpwDrawString(demotool_graphic,300,274,'LED indicator');
    display_one_line('In this example, none of the buttons have been selected, the buttons are "out" and the LED\'s, off');
 	amount_to_load(4 );
    display_one_line('If a button is pointed at by the mouse pointer, and the left hand mouse button pressed, ');
    set_button(button_table("im_intro"),IN);
    draw_block(200 fi_+CMD_BUTTON_WIDTH,270,25,2,BLUE);
    XpwDrawString(demotool_graphic,300,274,'LED indicator (selected)');
    draw_cmd_button_out(180,CMD_BUTTON_VERTICAL,CMD_BUTTON_WIDTH,CMD_BUTTON_HEIGHT,'Information','',,true,true);
 	amount_to_load( 5);
    display_one_line('then that button becomes the selected topic, the button changes state to show it is selected.');
    display_one_line('Lets suppose you select the Information command button.... ');
    draw_cmd_button_in(180,CMD_BUTTON_VERTICAL,CMD_BUTTON_WIDTH,CMD_BUTTON_HEIGHT,'Information','',true,true);
    display_one_line('The button changes its appearance to reflect the fact that it busy performing some task....');
 	amount_to_load(6 );
    display_one_line('e.g. say giving information on how to improve productivity by using POPLOG\'s immediate mode ');
    display_one_line('no other button may be selected while the command button is active, although events will be stored');
    display_one_line('When the command button returns from what ever it was doing, it resets its state.');
 	amount_to_load( 7);
    draw_cmd_button_out(180,CMD_BUTTON_VERTICAL,CMD_BUTTON_WIDTH,CMD_BUTTON_HEIGHT,'Information','',true,true);
    display_one_line('New pages may be activated by a topic button...');
    display_one_line('previous pages are reviewed one "level" at a time by selecting Previous Level. ');
    display_one_line('The Information button gives you detailed information on selected aspects of the demotool.');
 	amount_to_load( 8);
    display_one_line('The exit button allows you to leave the demotool, via a confim box... ');
    display_one_line('Its default setting is CANCEL,');
    display_one_line('             REMEMBER, command buttons are active ONLY while a topic button is selcted......');
 	amount_to_load(9 );
    display_one_line('             Any number of topic buttons may be "toggled" between on any given page  ....');
    display_one_line('             A topic button may itself bring up further pages of buttons, ');
    display_one_line('            and to see a previous page of butons, select the PREVIOUS LEVEL button.');
	amount_to_load(10);

    display_one_line('              The POPLOG DEMO SYSTEM was implemented using the POPLOG widget set.');
    XtRemoveAllCallbacks( demotool_graphic,
        XtN buttonEvent);
    activate(level_intro_index_buttons,demotool_graphic);
	false->button_selected;
    XtAddCallback( demotool_graphic,
        XtN buttonEvent,
        demotool_mb_cb,
        "clicked");

enddefine;

endsection;

/* --- Revision History ---------------------------------------------------
--- Julian Clinton, 15/10/92
	Updated version and date.
--- Julian Clinton, 25/11/91
	Changed bitmap names from .64.xbm to _64.xbm
*/
