/* --- Copyright University of Sussex 1991.  All Rights Reserved. ---------
 > File:            C.all/x/ui/lib/demotool_vars.p
 > Version :        1.34
 > Purpose:         variables for the demo system
 > Author:          J.D.POSTOYKO, June 1991
 > Documentation:
 > Related Files:
*/

compile_mode :pop11 +strict;


section $-demotool;
include xdefs.ph;

recordclass button
button_label
button_owner
button_shape
button_int
button_has_led
button_x_pos
button_y_pos
button_colour
button_string1
button_string2
button_string3
button_state
button_sensitive
button_procedure
button_variable
button_summary_file
;

constant
	SLIDE_SHOW =1 ,
	NEXT_PAGE = 2,
	PREVIOUS_PAGE =3 ,
	CONTENTS_PAGE = 4,
	SAVE_PAGE = 5,
	RESTORE_PAGE = 6,
	EXIT_DEMOTOOL = 7,
	OKAY_EXIT = 8,
	CANCEL_EXIT = 9,
	POPLOG_INTRO = 10,
	POPLOG_PRODUCTS = 11,
	POPLOG_LIBS = 12,
	APPLICATION_DEMOS = 13,
	INFORMATION = 14,
	PREVIOUS_LEVEL = 15,
	EXCAP_DEMO = 16,
	FAUST_DEMO = 17,
	ARBS_DEMO = 18,
	TASKER_DEMO = 19,
	IVE_DEMO = 20,
	HEAD_DEMO = 21,
	KBS_DEMO = 22,
	WALKER_DEMO = 23,
	FLEX_DEMO = 24,
	NEURAL_DEMO = 25,
	RULES_DEMO = 26,
	ABOUT_X = 27,
	ABOUT_MIXED_LANGUAGE_PROGRAMMING = 28,
	ABOUT_EXTERNAL_LANGUAGES = 29,
	ABOUT_VED = 30,
	ABOUT_INC_COMPILATION = 31,
	ABOUT_ONLINE_HELP = 32,
	ABOUT_SOURCE_LIBRARIES = 33,
	ABOUT_POP11 = 34,
	ABOUT_PROLOG = 35,
	ABOUT_LISP = 36,
	ABOUT_SML = 37,
	ABOUT_OOP = 38,
	DEMOTOOL_TUTORIAL = 39,
	POPLOG_TUTORIAL = 40,
    X_DEMO = 41,
    BLOCKS_DEMO = 42,
    ELIZA_DEMO = 43,
	;

constant
    IN  = 1,
    OUT = 0,
    NONE      = 0,
    SUMMARY   = 1,
    SLIDESHOW = 2,
    RUNDEMO   = 3,
    DISMISS   = 4,
    CHUNKY    = 0,
    CMD       = 1,
    RECT      = 2,
    WINDOW_WIDTH  = 575,
    WINDOW_HEIGHT = 360, ;;; 410
    IMAGE_WIDTH   = 575,
    IMAGE_HEIGHT  = 360,
    INTRO_WINDOW_WIDTH  = 575,
    INTRO_WINDOW_HEIGHT = 410,
    FIRST_IMAGE = 1,
    LAST_IMAGE  = 3,
    DELAY       = 6000,
    LED_WIDTH           = 14,
    LED_HEIGHT          = 6,
    CMD_BUTTON_VERTICAL = 310,
    CMD_BUTTON_WIDTH    =  70,
    CMD_BUTTON_HEIGHT   =  32,
    CMD_BUTTON_offset = round(WINDOW_WIDTH /5),
    TOP_LEFT = 0,
    TOP_RIGHT=1,
    BOTTOM_LEFT=2,
    BOTTOM_RIGHT=3,
    SPECIAL_EXCEPTION = 0;


constant poplog_hosts = [
	'SPARCstation'
	'Sun 3'
	'DECstation'
	'HP9000'
	'Silicon Graphics'
	'VAX/VMS'
	'80386'
	'Sequent Symmetry'
];

/* defined by Sun */
constant rt_magic = 16:59A66A95,
	rt_standard = 1,
	rmt_none = 0,
	rmt_equal_rgb = 1;

vars doing_something = false,
 temp,
 	width,
 	height,
 	depth,
 	len,
 	cm_type,
 	cm_len,
 	ive_rgb_cmap,
 	control_list,
 	i,
 	c,
 	set_demotool_size,
 	draw_block,
 	activate,
 	display_text_image,
	initial_display,
 	fname,
 	ix,
 	iy,
 	arr,
 	text_x,
 	text_y,
    p_mark_x = 10,
    p_mark_y = WINDOW_HEIGHT fi_-10,
    xorigin=10,
    yorigin=65,
    current_position = 1,
    list_length = length(subject_list),
    min_lim = true, max_lim = true,
    intro_to_poplog_stackmark = false,
    the_intro_next_button_locked = true,
    the_intro_previous_button_locked = true,
    requested_to_stop,
	list_length,
	control_list,
    release_lock ,
  	;

vars

   	times_bold_12,
    	font18,
    	FGC,
    	BGC,
    	BGC2 ,
    	BLACK ,
    	BLUE,
    	CYAN,
    	LED_ON,
    	LED_OFF,
    	RED_LED_ON
    	RED_LED_OFF,
    	CMD_BUTTON_IN_COLOR,
    	CMD_BUTTON_OUT_COLOR,
    	CMD_BUTTON_TEXT_COLOR,
        CMD_BUTTON_LIGHT_LINE,
        CMD_BUTTON_DARK_LINE,
        CHUNKY_BUTTON_TEXT_COLOR,
        screenType,
        Xtype,
;

#_IF XMOTIF
'/motif'->Xtype;
#_ELSEIF XOPENLOOK
'/openlook'->Xtype;
#_ENDIF

vars button_table = newproperty([],20,false,true),
    image_out_wr,
    image_in_wr,
    image_out_ro,
    image_in_ro,
    image_help,
    image_isl_logo,
    level_one_buttons,
    level_two_buttons,
    level_six_buttons,
    level_four_buttons,
    level_summary_buttons,
    level_intro_buttons,
    level_intro_buttons2 = false,
    level_intro_index_buttons,
    cmd_buttons,
    buttons_to_overlay = [],
    active_level_buttons = "AT_START",
    last_active_level = false,
    last_button_selected = false,
    last_button_level = false,
    last_cmd_button_selected,
    last_chunky_button_selected,
    last_demo_button_selected,
    button_on_which_mouse_pressed = false,
    button_selected,
    CHUNKY_BUTTON_WIDTH  = 86,
    CHUNKY_BUTTON_HEIGHT = 77,
    INTEGRATED = true,
	;

vars banner_img,
	mb0_img,
	mb1_img,
	mb2_img,
	mb3_img,
	machines_img,
    image_help_in
    image_help_out,
    demotool_widget2_display ,
	demotool_widget2_window,
    demotool_widget_display ,
	demotool_widget_window,
    summary_widget_display ,
	summary_widget_window,
    ;

vars demotool_pin = 1;
vars had_input requested_to_stop requested_to_exit stored_array image_has_mono_and_rgb=false;
vars the_button_clicked_on; ;;; global var used to see which MB pressed
vars procedure xor_state;
vars procedure display;
vars procedure draw_pin;
vars procedure xor_pinstate;
vars procedure show_intro_tool;
vars procedure button_dispatch;
vars procedure activate_intro_tool;
vars procedure sensitise;
vars procedure display_text;
vars procedure prompt_response;
vars procedure demotool_mb_cb;
vars procedure demotool_mb_cb2;
vars procedure demotool_mb_cb3;
vars procedure tutorial1;
vars procedure show_poplog_hosts;
vars procedure amount_to_load;
vars procedure demotool_sensitive;
vars procedure move_image;
vars  exit_action;
vars procedure give_demo_summary;
vars proc_to_apply;
vars procedure reset_demotool;
vars procedure show_intro_tool;
vars SLIDESHOW_HAS_BEEN_SEEN = false;
vars mouse_y_when_first_called, mouse_x_when_first_called;
vars last_active_level_buttons;
vars DEMO_PATH = [];"AT_START"::DEMO_PATH->DEMO_PATH;
vars first_time_requested_to_swop = true;
vars intro_to_poplog_stackmark= 0;
vars summary_widget summary_graphic;
vars tempGraphicSurface;
vars msg,
    demotool_widget = false,
    intro_shell = false,
    demotool_graphic,
    demotool_graphic2,
    demotool_widget2,
    extract, intro_tool_active,
    current_graphic_widget,
    current_demotool_widget,
    text_color,
	;

vars chrs_font = times_bold_12;
vars  ras_len ras_width ras_height ras_depth;
vars demotool_size = RUNDEMO;
vars intro_to_poplog_stackmark = false;

vars about_the_tool =[
	'$usepop/pop/x/ui/demo/src/text/demotool/demotool_text.1'
	'$usepop/pop/x/ui/demo/src/text/demotool/demotool_text.2'
	'$usepop/pop/x/ui/demo/src/text/demotool/demotool_text.3'
	'$usepop/pop/x/ui/demo/src/text/demotool/demotool_text.4'
	'$usepop/pop/x/ui/demo/src/text/demotool/demotool_text.5'
	'$usepop/pop/x/ui/demo/src/text/demotool/demotool_text.6'];

vars about_the_pds=about_the_tool;

vars about_intro_to_poplog =[
	'$usepop/pop/x/ui/demo/src/text/demotool/intro_text.1'];

vars about_the_products =[
	'$usepop/pop/x/ui/demo/src/text/demotool/prods_text.1'];

vars about_the_apps =[
	'$usepop/pop/x/ui/demo/src/text/demotool/apps_text.1'];

vars about_the_sourcelibs =[
	'$usepop/pop/x/ui/demo/src/text/demotool/sourcelibs_text.1'];

vars about_xwindows =[
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.1'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.2'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.3'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.4'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.5'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.6'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.7'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.8'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.9'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.10'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.11'
	'$usepop/pop/x/ui/demo/src/text/x/xwindows_text.12'
]; ;;;

vars about_ved=[
	'$usepop/pop/x/ui/demo/src/text/ved/ved_text.1'
	'$usepop/pop/x/ui/demo/src/text/ved/ved_text.2'
	'$usepop/pop/x/ui/demo/src/text/ved/ved_text.3'
]; ;;;

vars about_pop11 =[
	'$usepop/pop/x/ui/demo/src/text/pop11/pop11_text.1'
	'$usepop/pop/x/ui/demo/src/text/pop11/pop11_text.2'
	'$usepop/pop/x/ui/demo/src/text/pop11/pop11_text.3'
	'$usepop/pop/x/ui/demo/src/text/pop11/pop11_text.4'
	'$usepop/pop/x/ui/demo/src/text/pop11/pop11_text.5'
	'$usepop/pop/x/ui/demo/src/text/pop11/pop11_text.6'
	'$usepop/pop/x/ui/demo/src/text/pop11/pop11_text.7'
	'$usepop/pop/x/ui/demo/src/text/pop11/pop11_text.8'
]; ;;;

vars about_prolog =[
	'$usepop/pop/x/ui/demo/src/text/prolog/prolog_text.1'
	'$usepop/pop/x/ui/demo/src/text/prolog/prolog_text.2'
	'$usepop/pop/x/ui/demo/src/text/prolog/prolog_text.3'
	'$usepop/pop/x/ui/demo/src/text/prolog/prolog_text.4'
	'$usepop/pop/x/ui/demo/src/text/prolog/prolog_text.5'
]; ;;;

vars about_lisp =[
	'$usepop/pop/x/ui/demo/src/text/lisp/lisp_text.1'
	'$usepop/pop/x/ui/demo/src/text/lisp/lisp_text.2'
	'$usepop/pop/x/ui/demo/src/text/lisp/lisp_text.3'
	'$usepop/pop/x/ui/demo/src/text/lisp/lisp_text.4'
	'$usepop/pop/x/ui/demo/src/text/lisp/lisp_text.5'
	'$usepop/pop/x/ui/demo/src/text/lisp/lisp_text.6'
	'$usepop/pop/x/ui/demo/src/text/lisp/lisp_text.7'
]; ;;;

vars about_libraries=[
	'$usepop/pop/x/ui/demo/src/text/libraries/libraries_text.1'
	'$usepop/pop/x/ui/demo/src/text/libraries/libraries_text.2'
	'$usepop/pop/x/ui/demo/src/text/libraries/libraries_text.3'
]; ;;;

vars about_oop=[
	'$usepop/pop/x/ui/demo/src/text/oop/oop_text.1'
	'$usepop/pop/x/ui/demo/src/text/oop/oop_text.2'
	'$usepop/pop/x/ui/demo/src/text/oop/oop_text.3'
	'$usepop/pop/x/ui/demo/src/text/oop/oop_text.4'
	'$usepop/pop/x/ui/demo/src/text/oop/oop_text.5'
	'$usepop/pop/x/ui/demo/src/text/oop/oop_text.6'
	'$usepop/pop/x/ui/demo/src/text/oop/oop_text.7'
	'$usepop/pop/x/ui/demo/src/text/oop/oop_text.8'
	'$usepop/pop/x/ui/demo/src/text/oop/oop_text.9'
]; ;;;

vars about_mlp=[
	'$usepop/pop/x/ui/demo/src/text/mlp/mlp_text.1'
	'$usepop/pop/x/ui/demo/src/text/mlp/mlp_text.2'
	'$usepop/pop/x/ui/demo/src/text/mlp/mlp_text.3'
]; ;;;

vars about_inccomp=[
	'$usepop/pop/x/ui/demo/src/text/inccomp/inccomp_text.1'
	'$usepop/pop/x/ui/demo/src/text/inccomp/inccomp_text.2'
	'$usepop/pop/x/ui/demo/src/text/inccomp/inccomp_text.3'
];

vars about_help=[
	'$usepop/pop/x/ui/demo/src/text/help/help_text.1'
	'$usepop/pop/x/ui/demo/src/text/help/help_text.2'
	'$usepop/pop/x/ui/demo/src/text/help/help_text.3'
	'$usepop/pop/x/ui/demo/src/text/help/help_text.4'
	'$usepop/pop/x/ui/demo/src/text/help/help_text.5'
	'$usepop/pop/x/ui/demo/src/text/help/help_text.6'
]; ;;;

vars about_ml=[
	'$usepop/pop/x/ui/demo/src/text/ml/ml_text.1'
	'$usepop/pop/x/ui/demo/src/text/ml/ml_text.2'
	'$usepop/pop/x/ui/demo/src/text/ml/ml_text.3'
	'$usepop/pop/x/ui/demo/src/text/ml/ml_text.4'
	'$usepop/pop/x/ui/demo/src/text/ml/ml_text.5'
	'$usepop/pop/x/ui/demo/src/text/ml/ml_text.6'
	'$usepop/pop/x/ui/demo/src/text/ml/ml_text.7'
]; ;;;

vars about_external=[
	'$usepop/pop/x/ui/demo/src/text/external_lang/external_text.1'
	'$usepop/pop/x/ui/demo/src/text/external_lang/external_text.2'
	'$usepop/pop/x/ui/demo/src/text/external_lang/external_text.3'
]; ;;;


vars about_flex=[
	'$usepop/pop/x/ui/demo/applications/flex_demo/flex_text.1'
	'$usepop/pop/x/ui/demo/applications/flex_demo/flex_text.2'
	'$usepop/pop/x/ui/demo/applications/flex_demo/flex_text.3'
	'$usepop/pop/x/ui/demo/applications/flex_demo/flex_text.4'
	'$usepop/pop/x/ui/demo/applications/flex_demo/flex_text.5'
	'$usepop/pop/x/ui/demo/applications/flex_demo/flex_text.6'
	'$usepop/pop/x/ui/demo/applications/flex_demo/flex_text.7'
	'$usepop/pop/x/ui/demo/applications/flex_demo/flex_text.8'
]; ;;;

vars about_rules=[
	'$usepop/pop/x/ui/demo/applications/rules_demo/rules_text.1'
	'$usepop/pop/x/ui/demo/applications/rules_demo/rules_text.2'
	'$usepop/pop/x/ui/demo/applications/rules_demo/rules_text.3'
	'$usepop/pop/x/ui/demo/applications/rules_demo/rules_text.4'
	'$usepop/pop/x/ui/demo/applications/rules_demo/rules_text.5'
	'$usepop/pop/x/ui/demo/applications/rules_demo/rules_text.6'
	'$usepop/pop/x/ui/demo/applications/rules_demo/rules_text.7'
	'$usepop/pop/x/ui/demo/applications/rules_demo/rules_text.8'
]; ;;;

vars about_neural=[
	'$usepop/pop/x/ui/demo/applications/neural_demo/neural_text.1'
	'$usepop/pop/x/ui/demo/applications/neural_demo/neural_text.2'
	'$usepop/pop/x/ui/demo/applications/neural_demo/neural_text.3'
	'$usepop/pop/x/ui/demo/applications/neural_demo/neural_text.4'
	'$usepop/pop/x/ui/demo/applications/neural_demo/neural_text.5'
	'$usepop/pop/x/ui/demo/applications/neural_demo/neural_text.6'
]; ;;;


endsection;
