/* --- Copyright University of Sussex 1991.  All Rights Reserved. ---------
 > File:            C.all/x/ui/lib/rasterfile_utils.p
 > Version :        1.42
 > Purpose:         routines to create rasterfiles
 > Author:          J.D.POSTOYKO, May 1991
 > Documentation:
 > Related Files:
*/

section $-demotool;
compile_mode:pop11 +strict ;
/*
     rasterfile_info gives data on the size and type of a raster file
                     which can then be used to create pixmaps

     code taken from sunrasterfile.p

*/




    
define constant readint(dev) -> int;
    lvars int dev ;
        lconstant string = consstring(0, 0, 0, 0, 4);
        unless (sysread(dev, string, 4) ->> int) == 4 do
            mishap(int, dev, 2, 'unexpected lack of data in header')
        endunless;
        (subscrs(1, string) << 24)
        || (subscrs(2, string) << 16)
        || (subscrs(3, string) << 8)
        || subscrs(4, string) -> int
    
enddefine;


 
define constant misread(bytes);
       lvars bytes;
        unless sysread(bytes) == bytes do
            mishap('insufficient data in rasterfile');
        endunless;
    
enddefine;

define global rasterfile_info(file);
    lvars bytes_p_row extrabyte avec_index rasarr pixels_p_byte ;
    lvars int dev len pic width height depth file cm_len cm_type temp;
    lconstant eb_buf = inits(1);




    unless (sysopen(file, 0, false) ->> dev) do
        mishap(file, 1, 'file not found')
    endunless;
    unless (readint(dev) ->> temp) = rt_magic do
        mishap(file, temp, 2, 'not a rasterfile - bad magic number');
    endunless;
    readint(dev) -> ras_width  ;
    readint(dev) -> ras_height ;
    readint(dev) -> ras_depth  ;
    readint(dev) -> ras_len    ;
    unless (readint(dev) ->> temp) = rt_standard do
        mishap(file, temp, 2, 'rasterfile of type RT_STANDARD required');
    endunless;
    if (readint(dev) ->> cm_type) == rmt_none then
        false -> cm_type;
    elseunless cm_type == rmt_equal_rgb do
        mishap(file, cm_type, 2, 'rasterfile must have RMT_EQUAL_RGB type colour map');
    endif;
    unless (readint(dev) ->> temp) = 0 or cm_type do
        mishap(file, temp, 2, 'rasterfile must have zero length colour map');
    elseif cm_type and ((temp // 3) -> cm_len) /== 0 do
        mishap(file, temp, 2, 'rasterfile colour map length must be multiple of 3');
    endunless;

    sysclose(dev);
enddefine;


/*********** modified pwm_make_rasterarray.p to give :- ***********/

/* enhanced to take global information from rasterfile_info and to
   increase performance
*/

uses bitvectors;

 
define lconstant Spec_to_int(spec) -> spec;
	lvars spec;
	if spec == "byte" then
		8 -> spec
	elseif spec == "ushort" then
		16 -> spec
	elseif spec == "uint" or spec == "ulong" then
		32 -> spec
	endif
enddefine;

lconstant pa_keys = {% bitvector_key, false, 0, false, 0, 0, 0, false %};
lconstant pa_nap  = {% false, false, 0, false, 0, 0, 0, false %};

define lconstant get_newarr_proc(depth) -> proc;
	lvars depth proc key keyid name subit swap_subit;
	lconstant notonavax = conspair(false, false);

	define lconstant swapped_sub_1(x, vec, proc);
		lvars x vec proc;
		x fi_- 1 -> x;
		proc((x fi_&&~~ 7) fi_+ 8 fi_- (x fi_&& 7), vec);
	enddefine;
	;;;
	define lconstant uswapped_sub_1(v, x, vec, proc);
		lvars v x vec proc;
		x fi_- 1 -> x;
		proc(v, (x fi_&&~~ 7) fi_+ 8 fi_- (x fi_&& 7), vec);
	enddefine;

	define lconstant swapped_sub_2(x, vec, proc);
		lvars x vec proc;
		x fi_- 1 -> x;
		proc((x fi_&&~~ 3) fi_+ 4 fi_- (x fi_&& 3), vec);
	enddefine;
	;;;
	define lconstant uswapped_sub_2(v, x, vec, proc);
		lvars v x vec proc;
		x fi_- 1 -> x;
		proc(v, (x fi_&&~~ 3) fi_+ 4 fi_- (x fi_&& 3), vec);
	enddefine;

	define lconstant swapped_sub_4(x, vec, proc);
		lvars x vec proc;
		proc((if x fi_&& 1 == 0 then x fi_- 1 else x fi_+ 1 endif), vec);
	enddefine;
	;;;
	define lconstant uswapped_sub_4(v, x, vec, proc);
		lvars v x vec proc;
		proc(v, (if x fi_&& 1 == 0 then x fi_- 1 else x fi_+ 1 endif), vec);
	enddefine;

	if (subscrv(depth, pa_nap) ->> proc) == 0 then
		mishap(depth, 1, 'DEPTH MUST BE 1, 2, 4  or 8');
	elseunless proc do

		;;; make the key
		unless (subscrv(depth, pa_keys) ->> key) do
			consword('pwmrasv' >< depth) -> name;
			name <> "_key" -> keyid;
			sysSYNTAX(keyid, 0, false);
			sysGLOBAL(keyid);
			if iskey(valof(keyid) ->> key)
			and Spec_to_int(class_spec(key)) = depth then
				valof(keyid)
			else
				conskey(name, depth) ->> key_of_dataword(name)
			endif ->> valof(keyid) -> key;
			key -> subscrv(depth, pa_keys);
		endunless;

		;;; check if the bits are reversed
		unless front(notonavax) do
			initbitvector(1) -> subit;
			1 -> subit(1);
			(fast_subscrs(1, subit) == 128) -> back(notonavax);
			true ->> subit -> front(notonavax);
		endunless;
		;;; now make a newarray proc; with swapping subscriptor if required
		if depth == 8 or back(notonavax) then
			newanyarray(% key %)		;;; bits are right way round
		else							;;; bits need to be swapped
			class_subscr(key) -> subit;
			if depth == 1 then
				swapped_sub_1(% subit %) -> swap_subit;
				uswapped_sub_1(% subit.updater %) -> swap_subit.updater;
			elseif depth == 2 then
				swapped_sub_2(% subit %) -> swap_subit;
				uswapped_sub_2(% subit.updater %) -> swap_subit.updater;
			elseif depth == 4 then
				swapped_sub_4(% subit %) -> swap_subit;
				uswapped_sub_4(% subit.updater %) -> swap_subit.updater;
			endif;
			newanyarray(% key, swap_subit %)
		endif ->> proc -> subscrv(depth, pa_nap);
	endif;
enddefine;


define global demotool_make_rasterarray(bounds, depth) -> array;
	lvars bounds depth string newaproc newbounds array rx2;
	lvars x1 x2 y1 y2 bpr bbpr h si vi vec;
	if depth.isstring then
		bounds, depth -> string -> depth -> bounds;
	else
		false -> string;
	endif;

	checkinteger(depth, 1, 8);

	if bounds.destlist = 4 then
		-> y2 -> y1 -> x2 -> x1;
		unless x1.isinteger and x2.isinteger do
			mishap(x1, x2, 2, 'integer bounds needed')
		endunless;
	else
		mishap(bounds, 1, 'bit arrays must be two dimensional')
	endif;

	get_newarr_proc(depth) -> newaproc;
	x2 -> rx2;
	until erase((depth * (x2 fi_- x1 fi_+ 1)) fi_// 8) == 0 do
		x2 fi_+ 1 -> x2;
	enduntil;
	[% x1, x2, y1, y2 %] -> bounds;
	newaproc(bounds) -> array;
	rx2 -> subscrl(2, bounds);
	if string then
		depth * (x2 - x1 + 1) -> bpr;						;;; bits per row
		if (bpr // 8 -> bpr) > 0 then bpr + 1 -> bpr endif;	;;; bytes per row
		y2 - y1 + 1 -> h;
		bpr + erase(bpr // 2) -> bbpr;	;;; bytes per row rounded to 16 bits
		unless string.datalength == bbpr * h do
			mishap(string.datalength, h, bpr, bbpr, 4, 'bad length for raster string');
		endunless;
		array.arrayvector -> vec;
		0 ->> si -> vi;
		fast_repeat h times
			fast_for x1 from 1 to bpr do
				fast_subscrs(x1 fi_+ si, string)
					-> fast_subscrs(x1 fi_+ vi, vec);
			endfor;
			vi fi_+ bpr -> vi;
			si fi_+ bbpr -> si;
		endfast_repeat;
	endif;
enddefine;

;;; return the depth of an array, checking that it conforms 
;;; ;;;
define global demotool_rasterdepth(array) -> depth;
	lvars array depth x1 x2 y1 y2;
	array.arrayvector.datakey.class_spec.Spec_to_int -> depth;
	unless lmember(depth, [1 2 4 8]) do
		mishap(array, depth, 2,
				'depth of arrays for use with  must be power of 2');
	elseunless array.boundslist.destlist == 4 do
		mishap(array, 1, 'only two dimensional arrays can be used ');
	else
		-> y2 -> y1 -> x2 -> x1;
		y2 fi_- y1 fi_+ 1 -> y1;	;;; height
		x2 fi_- x1 fi_+ 1 -> x1;	;;; width
		if ((x1 fi_* depth) fi_// 8 -> x2) fi_> 0 then x2 + 1 -> x2 endif;
		;;; x2 is bytes per line - now see how many entries that is
		(x2 * 8) / depth -> x2;
		unless array.arrayvector.datalength == (x2 fi_* y1) do
			mishap(array, 1, 'badly-formatted array ');
		endunless;
	endunless;
enddefine;



/*********** modified pwmrasterfile.p to give :- ******************/
/* enhanced to take global information from rasterfile_info and to
   increase performance
*/



;;; NOTE: only handles type RT_STANDARD & colour map type RMT_EQUAL_RGB


global vars sunrasfile_colourmap = false;


define writeint(int, dev);
	lconstant string = consstring(0, 0, 0, 0, 4);
	lvars int dev;
	int && 255 -> subscrs(4, string);
	(int >> 8)  && 255 -> subscrs(3, string);
	(int >> 16) && 255 -> subscrs(2, string);
	(int >> 24) && 255 -> subscrs(1, string);
	syswrite(dev, string, 4);
enddefine;


define global demotool_rasterfile(file) -> rasarr;
	lvars bytes_p_row extrabyte avec_index rasarr pixels_p_byte;
	lvars dev  pic file cm_len cm_type temp;
	lconstant eb_buf = inits(1);

	unless (sysopen(file, 0, false) ->> dev) do
		mishap(file, 1, 'file not found')
	endunless;
	unless (readint(dev) ->> temp) = rt_magic do
		mishap(file, temp, 2, 'not a rasterfile - bad magic number');
	endunless;

    readint(dev) -> ras_width  ;
    readint(dev) -> ras_height ;
    readint(dev) -> ras_depth  ;
    readint(dev) -> ras_len    ;


	unless (readint(dev) ->> temp) = rt_standard do
		mishap(file, temp, 2, 'rasterfile of type RT_STANDARD required');
	endunless;
	if (readint(dev) ->> cm_type) == rmt_none then
		false -> cm_type;
	elseunless cm_type == rmt_equal_rgb do
		mishap(file, cm_type, 2, 'rasterfile must have RMT_EQUAL_RGB type colour map');
	endif;
	unless (readint(dev) ->> temp) = 0 or cm_type do
		mishap(file, temp, 2, 'rasterfile must have zero length colour map');
	elseif cm_type and ((temp // 3) -> cm_len) /== 0 do
		mishap(file, temp, 2, 'rasterfile colour map length must be multiple of 3');
	endunless;

	demotool_make_rasterarray([1 ^ras_width 1 ^ras_height], ras_depth) -> rasarr;

	if ((ras_width * ras_depth) // 8 -> bytes_p_row) > 0 then
		bytes_p_row + 1 -> bytes_p_row;
	endif;

	if erase(bytes_p_row // 2) == 0 then false else eb_buf endif -> extrabyte;

	;;; now read colourmap info, if any
	if cm_type then
		repeat cm_len times
			repeat 3 times
				misread(dev, eb_buf, 1);
				fast_subscrs(1, eb_buf);
			endrepeat;
			consvector(3);
		endrepeat;
		consvector(cm_len);
	else
		false
	endif -> sunrasfile_colourmap;

	;;; now read image data
	1 -> avec_index;

	repeat ras_height times
		misread(dev, avec_index, rasarr.arrayvector, bytes_p_row);
		avec_index + bytes_p_row -> avec_index;
		if extrabyte then
			misread(dev, extrabyte, 1);
		endif;
	endrepeat;

	sysclose(dev);
enddefine;

define updaterof global demotool_rasterfile(rasarr, file);
	lvars rasarr file avec dev width height depth a_index arr_bpr fil_bpr;
	lvars x1 x2 y1 y2;
	lconstant nullfield = consstring(0, 0, 0, 0, 4);

	;;; this also checks properly formatted (byte-aligned) etc
	rasarr.demotool_rasterdepth -> depth;

	rasarr.boundslist.destlist ->; -> y2 -> y1 -> x2 -> x1;
	x2 - x1 + 1 -> width;
	y2 - y1 + 1 -> height;

	rasarr.arrayvector -> avec;

	;;; arr_bpr is bytes per row in the array vector,
	;;; fil_bpr is bytes per row to be written to the file
	if ((width * depth) // 8 -> arr_bpr) > 0 then arr_bpr + 1 -> arr_bpr endif;
	if erase(arr_bpr // 2) > 0 then arr_bpr + 1 else arr_bpr endif -> fil_bpr;

	syscreate(file, 1, false) -> dev;

	writeint(rt_magic, dev);                ;;; magic number
	writeint(width, dev);                   ;;; width in pixels
	writeint(height, dev);                  ;;; height in pixels
	writeint(depth, dev);                   ;;; depth in bits/pixel
	writeint(fil_bpr * height, dev);        ;;; bytes of data
	writeint(rt_standard, dev);             ;;; raster file type
	syswrite(dev, nullfield, 4);            ;;; maptype
	syswrite(dev, nullfield, 4);            ;;; maplength

	1 -> a_index;
	repeat height times
		syswrite(dev, a_index, avec, arr_bpr);
		unless arr_bpr == fil_bpr do
			syswrite(dev, nullfield, 1);    ;;; pad rows to 16 bit multiples
		endunless;
		a_index + arr_bpr -> a_index;
	endrepeat;

	sysclose(dev);
enddefine;


endsection;
