/* --- Copyright University of Sussex 1991.  All Rights Reserved. ---------
 > File:            C.all/x/ui/lib/slide_data.p
 > Version :        1.13
 > Purpose:         data for the ISL POPLOG DEMO SYSTEM slide show
 > Author:          J.D.POSTOYKO, May 1991
 > Documentation:
 > Related Files:
 */
 section $-demotool ;
compile_mode:pop11 +strict ;

include xdefs.ph;
#_IF DEF XMOTIF 

 constant
     image_width = 1152,
     image_height = 900,
     viewport_width = 1000,
     viewport_height = 730;

#_ELSE
 constant
     image_width = 1152,
     image_height = 900,
     viewport_width = 1000,
     viewport_height = 865;
#_ENDIF

 uses newrandom;

define excap_rgb_cmap();
if isrgb then
    	 XpwChangeColor(current_graphic_widget,  20 , 0,0,255);

endif;;

enddefine;


 define head_rgb_cmap();
	 if isrgb then
    	 lvars i c;
    	 fast_for i from 16 to 124 do
        	 fi_min(i fi_*2, 255) -> c;
        	 if (i fi_mod 2 == 0 or i fi_>112) then
            	 XpwChangeColor(current_graphic_widget, i fi_+ text_color, c, 112,20);
        	 else
        	 endif;
    	 endfast_for;

    	 XpwChangeColor(current_graphic_widget,  LED_OFF , 0, 170, 0);
    	 XpwChangeColor(current_graphic_widget,  LED_ON, 140, 255, 140);
    	 XpwChangeColor(current_graphic_widget,  RED_LED_OFF ,200,0,0);
    	 XpwChangeColor(current_graphic_widget,  RED_LED_ON, 255,90,90);

		 ;;; next the green exterior
    	 fast_for i from 89 by 4 to 170 do
        	 fi_min(i fi_*1, 255) -> c;
             XpwChangeColor(current_graphic_widget, i ,0,c,0);
    	 endfast_for;

		 ;;; next the red interior
    	 fast_for i from 90 by 4 to 170 do
			 if i == 102 then
				 ;;; seems to be a bug which prevents you from setting 102 !
			 else
        		 fi_min(i fi_*1, 255) -> c;
            	 XpwChangeColor(current_graphic_widget, i ,c,10,0);
			 endif;
		 endfast_for;

		 ;;; then the eyes orange
    	 fast_for i from 71 by 4 to 147 do
        	 fi_min(i fi_*1, 250) -> c;
             XpwChangeColor(current_graphic_widget, i ,255,c+10,10);
    	 endfast_for;

	 endif;
 enddefine;


 define ive_bw_cmap();
	 if isrgb then

		 lvars j;
		 40->i;
         for j from 255 by -6 to 60 do
             XpwChangeColor(current_graphic_widget, i,j,j,j);
			 i+1->i;
		 endfor;
/*
fast_for i from 40  to 68 do
     		255 fi_- fi_min((i) fi_*2, 200) -> c;
            XpwChangeColor(current_graphic_widget, i ,c,c,c);
    	endfast_for;
		 */

	 endif;

 enddefine;




 define ive_rgb_cmap();
	 if isrgb then

		 XpwChangeColor( demotool_graphic2,60,100,250,100);
		 XpwChangeColor( demotool_graphic2,63,200,250,100);
		 XpwChangeColor( demotool_graphic2,64,120,230,100);
		 XpwChangeColor( demotool_graphic2,65,120,230,90);
		 XpwChangeColor( demotool_graphic2,66,100,200,90);
		 XpwChangeColor( demotool_graphic2,67,120,200,60);
		 XpwChangeColor( demotool_graphic2,68,120,200,0);
		 XpwChangeColor( demotool_graphic2,69,140,200,0);

		 XpwChangeColor( demotool_graphic2,50,120,250,150);
		 XpwChangeColor( demotool_graphic2,51,140,250,150);
		 XpwChangeColor( demotool_graphic2,52,150,200,140);
		 XpwChangeColor( demotool_graphic2,53,170,200,140);
		 XpwChangeColor( demotool_graphic2,54,180,150,130);
		 XpwChangeColor( demotool_graphic2,55,190,150,130);
		 XpwChangeColor( demotool_graphic2,56,210,100,150);
		 XpwChangeColor( demotool_graphic2,57,220,100,150);
		 XpwChangeColor( demotool_graphic2,58,240,100,150);
		 XpwChangeColor( demotool_graphic2,59,255,100,150);

		 XpwChangeColor( demotool_graphic2,40,100,20,20);
		 XpwChangeColor( demotool_graphic2,41,0,0,200);
		 XpwChangeColor( demotool_graphic2,42,0,0,255);
		 XpwChangeColor( demotool_graphic2,43,0,200,250);
		 XpwChangeColor( demotool_graphic2,44,0,250,200);
		 XpwChangeColor( demotool_graphic2,45,200,100,0);
		 XpwChangeColor( demotool_graphic2,46,200,200,0);
		 XpwChangeColor( demotool_graphic2,47,220,0,0);
		 XpwChangeColor( demotool_graphic2,48,240,0,0);
		 XpwChangeColor( demotool_graphic2,49,255,0,0);

	 endif;
 enddefine;


 define head_bw_cmap();
	 if isrgb then

		 ive_bw_cmap();

    	 fast_for i from 40  to 80 do
     		 255 fi_- fi_min(i fi_*2, 255) -> c;
			 ;;;     50->c;
             XpwChangeColor(current_graphic_widget, i ,c,c,c);
			 ;;;            XpwChangeColor(current_graphic_widget, i ,c+random(200),c+random(200),c+random(200));
    	 endfast_for;

    	 fast_for i from 40 by 4 to 236 do
     		 fi_min(i fi_*1, 255) -> c;
			 XpwChangeColor(current_graphic_widget, i ,c,c,c);
		 endfast_for;

    	 fast_for i from 41 by 4 to 240 do
     		 fi_min(i fi_*1, 255) -> c;
			 XpwChangeColor(current_graphic_widget, i ,c,50,40);
		 endfast_for;
         XpwChangeColor(current_graphic_widget,32,30,50,40);

	 endif;

 enddefine;



 define head_bw_rgb_cmap();
 	 head_rgb_cmap();

	 if isrgb then

		 ive_bw_cmap();

    	 fast_for i from 40  to 80 do
     		 255 fi_- fi_min(i fi_*2, 255) -> c;
			 ;;;     50->c;
             XpwChangeColor(current_graphic_widget, i ,c,c,c);
			 ;;;            XpwChangeColor(current_graphic_widget, i ,c+random(200),c+random(200),c+random(200));
    	 endfast_for;

    	 fast_for i from 40 by 4 to 236 do
     		 fi_min(i fi_*1, 255) -> c;
			 XpwChangeColor(current_graphic_widget, i ,c,c,c);
		 endfast_for;

	 endif;
 enddefine;

 define sat_rgb_cmap();
	 if isrgb then

    	 fast_for i from 40  to 68 do
     		 255 fi_- fi_min(i fi_*2, 255) -> c;
     		 50->c;
			 ;;;            XpwChangeColor(current_graphic_widget, i ,c,c,c);
             XpwChangeColor(current_graphic_widget, i ,c+random(200),c+random(200),c+random(200));
    	 endfast_for;

	 endif;

 enddefine;


 define walker_rgb_cmap();
	 if isrgb then

    	 fast_for i from 40 by 4 to 236 do
     		 fi_min(i fi_*1, 255) -> c;
			 XpwChangeColor(current_graphic_widget, i ,c,c,c);
		 endfast_for;

    	 fast_for i from 41 by 4 to 240 do
     		 fi_min(i fi_*1, 255) -> c;
			 XpwChangeColor(current_graphic_widget, i ,c,50,40);
		 endfast_for;
         XpwChangeColor(current_graphic_widget,32,30,50,40);

	 endif;

 enddefine;

/****************************************************
Now the tables of data to drive the slide show
 *****************************************************/

 vars slide_holder = newproperty([],25,false,true);
 recordclass slide
 text
 image
 proc
 ;

 /* a blank record used in the slide show */

 consslide('',
     '',
     identfn
 )->slide_holder("temp_store");


 ;;; in each of the demo directories is a file, demoname_demo.p
 ;;; it contains the information relating to the slide show for
 ;;; each demo (currently rules flex and neural are exceptions
 ;;; in that they only contain text files, no images)
 ;;; if the demo has not been installed, then the file is
 ;;; unreadable, and so a [] is assigned to the demos slides.
 ;;; The button will still be displayed to the user, but without
 ;;; the LED, and selection of it will give a
 ;;;
 ;;; This demo has not been installed - see you POPLOG Administrator
 ;;;
 ;;; message.


/**********************************************************
S e t   u p   t h e   I V E    s l i d e   s h o w
 **********************************************************/
 if readable('$usepop/pop/x/ui/demo/applications/ive_demo/ive_demo.p') then
	 compile('$usepop/pop/x/ui/demo/applications/ive_demo/ive_demo.p');
 else
	 vars ive_slides = [];
 endif;


/**********************************************************
S e t   u p   t h e   F A U S T   s l i d e   s h o w
 **********************************************************/
 if readable('$usepop/pop/x/ui/demo/applications/faust_demo/faust_demo.p') then
	 compile('$usepop/pop/x/ui/demo/applications/faust_demo/faust_demo.p');
 else
	 vars faust_slides = [];
 endif;


/**********************************************************
S e t   u p   t h e   T A S K E R   s l i d e   s h o w
 **********************************************************/
 if readable('$usepop/pop/x/ui/demo/applications/tasker_demo/tasker_demo.p') then
	 compile('$usepop/pop/x/ui/demo/applications/tasker_demo/tasker_demo.p');
 else
	 vars tasker_slides = [];
 endif;


/**********************************************************
S e t   u p   t h e   A R B S   s l i d e   s h o w
 **********************************************************/
 if readable('$usepop/pop/x/ui/demo/applications/arbs_demo/arbs_demo.p') then
	 compile('$usepop/pop/x/ui/demo/applications/arbs_demo/arbs_demo.p');
 else
	 vars arbs_slides = [];
 endif;


/**********************************************************
S e t   u p   t h e   E X C A P   s l i d e   s h o w
 **********************************************************/
 if readable('$usepop/pop/x/ui/demo/applications/excap_demo/excap_demo.p') then
	 compile('$usepop/pop/x/ui/demo/applications/excap_demo/excap_demo.p');
 else
	 vars excap_slides = [];
 endif;


/**********************************************************
S e t   u p   t h e   H E A D   s l i d e   s h o w
 **********************************************************/
 if readable('$usepop/pop/x/ui/demo/applications/xmed_demo/xmed_demo.p') then
	 compile('$usepop/pop/x/ui/demo/applications/xmed_demo/xmed_demo.p');
 else
	 vars xmed_slides = [];
 endif;


/**********************************************************
S e t   u p   t h e   I M A G E S    s l i d e   s h o w
 **********************************************************/
 if readable('$usepop/pop/x/ui/demo/applications/sat_demo/sat_demo.p') then
	 compile('$usepop/pop/x/ui/demo/applications/sat_demo/sat_demo.p');
 else
	 vars sat_slides = [];
 endif;

/**********************************************************
S e t   u p   t h e   W A L K E R   s l i d e   s h o w
 **********************************************************/
 if readable('$usepop/pop/x/ui/demo/applications/walker_demo/walker_demo.p') then
	 compile('$usepop/pop/x/ui/demo/applications/walker_demo/walker_demo.p');
 else
	 vars walker_slides = [];
 endif;


 endsection;
