
section $-lisp;


define lconstant Search_env(env, sym, flags);
    lvars env flags ftok sym;
    car(env) ->;                    ;;; check "env" is a list
    symbol_string(sym) ->;          ;;; check "sym" is a symbol
    (list_assoc(sym, env) ->> ftok)
        and
    (ft_flags(ftok) &&/=_0 flags)
        and
    ft_valof(ftok)
enddefine;


define lconstant Extend_env(Local_function_tokens, functions, macros)
                                -> Local_function_tokens;
    lvars ftok functions item macros name pdr;
    for item in functions do
        car(item) -> name;
        lisp_error(% 'Applying unbound lexical function', [^name] %) -> pdr;
        lispFUNCTION(name, _FT_FUNCTION _biset _FT_LOCAL);
        lispFASSIGN(pdr, name)
    endfor;
    for item in macros do
        car(item) -> name;
        cadr(item) -> pdr;

        consfunction_token(name) ->> ftok -> current_sf_token(name);
        sysLCONSTANT(ftok, 0);
        sys_current_ident(ftok) -> fast_cont(ftok);
        ft_perm_flags(ftok) _biset (_FT_LOCAL _biset _FT_MACRO)
            -> ft_flags(ftok);
        pdr -> valof(ftok);

    endfor
enddefine;


lisp_export(Search_env(% _FT_MACRO %), @ENVIRONMENT-MACRO, "boolean");

lisp_export(Search_env(% _FT_FUNCTION %), @ENVIRONMENT-FUNCTION, "boolean");

lisp_export(Extend_env, @WITH-AUGMENTED-ENVIRONMENT-INTERNAL, [3 3 1]);


endsection;
