
section $-lisp;

define fin_data =
    newanyproperty([], 32, 1, 32, false, false, "tmparg", false,
                    procedure(fin, prop);
                        lvars fin prop;
                        newproperty([], 16, nil, "tmparg")
                            ->> prop(fin)
                    endprocedure)
enddefine;


define lconstant Undef_fin_error();
    lisp_error('Applying undefined funcallable instance', [])
enddefine;


define init_fin() -> fin;
    lvars fin fni;
    writeable fast_apply(% Undef_fin_error %) -> fin;
    writeable new_function_info(gensymbol(@FIN))
            ->> fni -> function_info(fin);
    fill_function_info(fni, 0, false, false);
enddefine;


define is_fin(item);
    lvars item;
    isprocedure(item) and pdpart(item) == fast_apply
enddefine;


define lconstant Checkr_fin(item) -> item;
    lvars item;
    unless is_fin(item) do
        mishap(item, 1, 'FUNCALLABLE INSTANCE NEEDED')
    endunless
enddefine;


define set_fin_pdr(fin, pdr) -> fin;
    lvars fin pdr;
    checkr_function(pdr) -> fast_frozval(1, Checkr_fin(fin))
enddefine;


define fin_datum(fin, key);
    lvars key fin;
    fast_apply(key, fin_data(Checkr_fin(fin)))
enddefine;


define updaterof fin_datum(val, fin, key);
    lvars fin key val;
    val -> fast_apply(key, fin_data(Checkr_fin(fin)))
enddefine;


lisp_export(init_fin, @ALLOCATE-FUNCALLABLE-INSTANCE-1, [0 0 1]);

lisp_export(is_fin, @FUNCALLABLE-INSTANCE-P, "boolean");

lisp_export(set_fin_pdr, @SET-FUNCALLABLE-INSTANCE-FUNCTION, [2 2 1]);

lisp_export(fin_datum, @FUNCALLABLE-INSTANCE-DATA-1, [2 2 1]);


endsection;
