#|
    Some CLOS test examples.
|#

(defclass lock ()
    ((name  :initarg :name
            :reader lock-name))
    (:documentation "The foundation of all locks"))

(defclass null-lock (lock) ()
    (:documentation "A lock which is always free"))

(setq *nl* (make-instance 'null-lock :name 'test-lock))

(defclass simple-lock (lock)
    ((owner     :initform nil
                :accessor lock-owner))
    (:documentation "A lock which is either free or busy"))

(setq *sl* (make-instance 'simple-lock :name 'my-lock))

(lock-name *sl*)
(lock-owner *sl*)
(setf (lock-owner *sl*) 'danny)
(lock-owner *sl*)

(defun make-simple-lock (name)
    (make-instance 'simple-lock :name name))

(defun make-null-lock (name)
    (make-instance 'null-lock :name name))

(setq *lock-a* (make-null-lock 'a))
(setq *lock-b* (make-null-lock 'b))

(type-of *lock-a*)
(type-of *lock-b*)

(class-of "a")
(class-of 'a)

(class-of *lock-a*)
(class-of *lock-b*)

(find-class 'null-lock)
(typep *lock-a* 'null-lock)
(typep *lock-a* (class-of *lock-a*))

(defgeneric seize (lock)
    (:documentation
    "Seizes the lock. Returns the lock when operation succeeds.
    Some locks wait until they can succeed;
    other locks return NIL if they fail."))

(defgeneric release (lock &optional failure-mode)
    (:documentation
    "Release the lock if owned by this process.
    Returns T if operation succeeds. If unsuccessful, signals
    when failure-mode=:error, otherwise returns NIL."))

(defgeneric lockp (x)
    (:documentation "T iff x supports the lock protocol."))

(defmethod seize ((nl null-lock))
    nl)

(defmethod release ((nl null-lock) &optional failure-mode)
    t)

(defmethod print-object ((lock lock) stream)
    (format stream "#<~S ~A>"
        (type-of lock)
        (lock-name lock))
    lock)

(defmethod lockp ((x lock)) t)

(defmethod lockp (x) nil)

(defclass ordered-lock-mixin (lock)
    ((level :initarg :level
            :reader lock-level)))

(defclass ordered-lock (ordered-lock-mixin simple-lock) ())

(defclass ordered-null-lock (ordered-lock-mixin null-lock) ())

(defun make-ordered-lock (name level)
    (make-instance  'ordered-lock
                    :name name
                    :level level))
