#|
    Some CLOS test examples
|#

(defclass meter ()
    ((reading    :initarg :reading
                 :reader meter-reading)))

(defclass positive-meter (meter) ())

(defmethod (Setf meter-reading) (new-value (m meter))
    (unless (equal new-value (slot-value m 'reading))
        (setf (slot-value m 'reading) new-value)))

(defmethod (setf meter-reading) (new-value (m positive-meter))
    (if (>= new-value 0)
        (call-next-method)
        (call-next-method 0 m)))

(defclass positive-mixin () ())

(defmethod (setf meter-reading) (new-value (m positive-mixin))
    (if (>= new-value 0)
        (call-next-method)
        (call-next-method 0 m)))

(defclass positive-meter (positive-mixin meter) ())

(defclass positive-bar-gauge (positive-mixin bar-gauge) ())
