#|
    Some CLOS test examples.
    Taken from CLtL2, p820
|#

(defclass position () ())

(defclass x-y-position (position)
    ((x :initform 0 :initarg :x)
     (y :initform 0 :initarg :y)))

(defclass rho-theta-position (position)
    ((rho :initform 0)
     (theta :initform 0)))

(defmethod update-instance-for-different-class :before
    ((old x-y-position)
     (new rho-theta-position) &key)
(let ((x (slot-value old 'x))
      (y (slot-value old 'y)))
    (setf (slot-value new 'rho) (sqrt (+ (* x x) (* y y)))
          (slot-value new 'theta) (atan y x))))

(setq p1 (make-instance 'x-y-position :x 2 :y 0))

(change-class p1 'rho-theta-position)
