/*  --- Copyright University of Sussex 1986.  All rights reserved. ---------
 > File:           $usepop/master/C.all/lib/sun/pwmsgraphics.p
 > Purpose:        Graphics primitives for Sun PWM
 > Author:         Ben Rubinstein, Apr  1 1986
 > Documentation:  HELP *PWMGRAPHICS
 > Related Files:  LIB *PWMSUNUTILS *VEDPWMSUN
 */

uses ioctl_sgttyb;

recordclass sgttyb
	dummy:full       /* dummy first field */
	sg_ispeed:8      /* input speed */
	sg_ospeed:8      /* output speed */
	sg_erase:8       /* erase character */
	sg_kill:8        /* kill character */
	sg_flags:16      /* mode flags */
	;

constant pwms_selectgfx = '\^[{G';

constant pwmc_numberterm = `t`;
constant pwms_stringterm = '\^[\\';

constant pwms_grafline      = '\^[{gl';
constant pwms_grafparams    = '\^[{gp';
constant pwms_graftext      = '\^[}gt';
constant pwms_grafvalue     = '\^[{gv';
constant pwms_grafdumpraster = '\^[{gd';
constant pwms_grafreadraster = '\^[{gr';
constant pwms_grafwipe      = '\^[{gw';

;;; setrawmode(<device>, true);
;;;     set the "RAW" flag on the device
;;;
;;; setrawmode(<device>, false)
;;;     reset the "RAW" flag on the device
;;;
define setrawmode(device, raw);
	vars sg;
	conssgttyb(0, 0, 0, 0, 0, 0) ->  sg;
	if      sys_io_control(device, TIOCGETP, sg)
	then    (if raw then RAW else 0 endif)
							|| (sg.sg_flags &&~~ RAW) -> sg.sg_flags;
			unless  sys_io_control(device, TIOCSETP, sg)
			do      mishap(device, 1, 'unable to set device parameters');
			endunless
	else
			mishap(device, 1, 'unable to get device parameters');
	endif
enddefine;

;;; check that arg is non-negative integer: term is something to send to PWM
;;; before crashing out, to terminate the current command cleanly.
;;;
define checkgrafarg(term, n);
	lvars term n mess;
	if n.isinteger then
		if n fi_>= 0 then
			return
		else
			'non-negative argument needed for graphic command'
		endif;
	else
		'integer argument needed for graphic command'
	endif -> mess;
	if term then
		rawcharout(term);
		sysflush(popdevraw);
	endif;
	mishap(n, 1, mess);
enddefine;

vars     pwm_grafselected = 0;

;;; select window <number> for subsequent graphics operations (window may be
;;; text or graphics)
;;;
define pwm_grafselect(number);
	checkgrafarg(false, number);
	appdata(pwms_selectgfx, rawcharout);
	rawcharout(number + 32);
	rawcharout(pwmc_numberterm);
	sysflush(popdevraw);
	number -> pwm_grafselected;
enddefine;

;;; wipe over the defined rectangle of the current graphics window with the
;;; current graphics op (preferably something sensible...)
;;;
define pwm_grafwipe(height);
	lvars top, left, width, height;
	vars cucharout;
	if height then
		-> width;
		-> left;
		-> top;
		checkgrafarg(false, height);
		checkgrafarg(false, width);
		checkgrafarg(false, left);
		checkgrafarg(false, top);
		rawcharout -> cucharout;
		syswrite(popdevraw, pwms_grafwipe, #_< pwms_grafwipe.datalength >_#);
		pr(top);
		rawcharout(`;`);
		pr(left);
		rawcharout(`;`);
		pr(width);
		rawcharout(`;`);
		pr(height);
		rawcharout(pwmc_numberterm);
	else
	syswrite(popdevraw,
					#_< pwms_grafwipe <> '0;0;0;0' <>
								consstring(pwmc_numberterm, 1) >_# ,
					#_< pwms_grafwipe.datalength + 8 >_#);
	endif;
	sysflush(popdevraw);
enddefine;

;;; coords is either a list of coordinates [x1 y1 x2 y2 ...], or the number
;;; of coords on the stack.  If there are coords on the stack, they may be
;;; either integers, stacked x first, or subscriptable structures with at
;;; least two elements, eg a list or a vector.
;;;
;;; Thus to draw a square, either
;;;     pwm_grafline([0 0 0 5 5 5 5 0 0 0])
;;; or
;;;     pwm_grafline(0, 0, 0, 5, 5, 5, 5, 0, 0, 0, 5)
;;; or
;;;     pwm_grafline({0 0}, {0 5}, {5 5}, {5 0}, {0 0}, 5)
;;;
define pwm_grafline(coords);
	lvars x y;
	vars cucharout;
	if coords.islist then
		explode(coords);
		(coords.length) / 2 -> coords;
		unless coords.isinteger do
			mishap(0, 'odd number of coordinates');
		endunless;
	endif;
	syswrite(popdevraw, pwms_grafline, #_< pwms_grafline.datalength >_#);
	rawcharout -> cucharout;
	rawcharout -> cucharout;
	vars cucharout;
	repeat coords - 1 times
		-> y;
		unless y.isinteger do y(1), y(2) -> y; endunless -> x;
		checkgrafarg(`t`, x);
		checkgrafarg(`t`, y);
		pr(x);
		rawcharout(`;`);
		pr(y);
		rawcharout(`;`);
	endrepeat;
	-> y;
	unless y.isinteger do y(1), y(2) -> y; endunless -> x;
	checkgrafarg(`t`, x);
	checkgrafarg(`t`, y);
	pr(x);
	rawcharout(`;`);
	pr(y);
	rawcharout(`t`);
	sysflush(popdevraw);
enddefine;

;;; set the operation and value for subsequent graphics commands
;;;     (applies to all windows)
;;;
define pwm_grafparams(op, val);
	vars cucharout;
	checkgrafarg(false, op);
	checkgrafarg(false, val);
	rawcharout -> cucharout;
	syswrite(popdevraw, pwms_grafparams, #_< pwms_grafparams.datalength >_#);
	pr(op);
	rawcharout(`;`);
	pr(val);
	rawcharout(pwmc_numberterm);
	sysflush(popdevraw);
enddefine;

;;; draw a raster of the given width and height (pixel values), in the
;;; current graphics window
;;;
define pwm_grafdumpraster(left, top, width, height, depth, s);
	vars len s2 cucharout;
	checkgrafarg(false, left);
	checkgrafarg(false, top);
	checkgrafarg(false, width);
	checkgrafarg(false, height);
	checkgrafarg(false, depth);
	width * depth -> len;
	if (len // 16 -> len) > 0 then
		height  * 2 * (len + 1)
	else
		height  * 2 * len
	endif -> len;

	unless s.datalength == len do
		mishap(width, height, len, s.datalength, 4,
								'bad string size for picture');
	endunless;

	rawcharout -> cucharout;
	syswrite(popdevraw, pwms_grafdumpraster,
				#_< pwms_grafdumpraster.datalength >_#);
	pr(left);
	rawcharout(`;`);
	pr(top);
	rawcharout(`;`);
	pr(width);
	rawcharout(`;`);
	pr(height);
	rawcharout(pwmc_numberterm);
	setrawmode(popdevraw, true);
	syswrite(popdevraw, s, len);
	sysflush(popdevraw);
	setrawmode(popdevraw, false);
enddefine;

;;; get a raster for the given rectangle of the current graphics window
;;;
define pwm_grafreadraster(left, top, width, height, depth) -> s;
	vars len x cucharout;   
	checkgrafarg(false, left);
	checkgrafarg(false, top);
	checkgrafarg(false, width);
	checkgrafarg(false, height);
	checkgrafarg(false, depth);
	width * depth -> len;       ;;; len is bits per line
	if  (len // 16 -> len) > 0 then
		(len + 1) * 2
	else
		len * 2
	endif -> len;               ;;; len is bytes per line
	inits(len * height) -> s;
	rawcharout -> cucharout;
	setrawmode(popdevraw, true);
	syswrite(popdevraw, pwms_grafreadraster,
				#_< pwms_grafreadraster.datalength >_#);
	pr(left);
	rawcharout(`;`);
	pr(top);
	rawcharout(`;`);
	pr(width);
	rawcharout(`;`);
	pr(height);
	rawcharout(pwmc_numberterm);
	sysflush(popdevraw);
	for x from 1 to len * height do
		rawcharin() -> s(x);
	endfor;
	setrawmode(popdevraw, false);
enddefine;

;;; print string in current graphics window: x, y specify pixel coordinates
;;; of left edge and baseline of first character; all characters are printed
;;; straight; line will be clipped to right edge of window.
;;;
define pwm_graftext(x, y, string);
	vars cucharout;
	checkgrafarg(false, x);
	checkgrafarg(false, y);
	rawcharout -> cucharout;
	syswrite(popdevraw, pwms_graftext, #_< pwms_graftext.datalength >_#);
	pr(x);
	rawcharout(`;`);
	pr(y);
	rawcharout(`;`);
	syswrite(popdevraw, string, string.datalength);
	syswrite(popdevraw, pwms_stringterm, #_< pwms_stringterm.datalength >_#);
	sysflush(popdevraw);
enddefine;

;;; get the value of the pixel at (x, y) in the current graphics window
;;;
define pwm_grafvalue(x, y) -> v;
	lvars x y s v;
	vars cucharout;
	checkgrafarg(false, x);
	checkgrafarg(false, y);
	rawcharout -> cucharout;
	syswrite(popdevraw, pwms_grafvalue, #_< pwms_grafvalue.datalength >_#);
	pr(x);
	rawcharout(`;`);
	pr(y);
	pwms_grafvalue <> (x >< ';' >< y) <> -> s;
	get_tty_report(#_< consstring(pwmc_numberterm, 1) >_#, '\^[{Z', `t`) -> v;
	if v.isstring and v.datalength == 1 then v(1) - 32 else false endif -> v;
enddefine;

vars pwmsungraph = true;    ;;; for loading with "uses"
