;;; Update Poplog on a remote system -- JG Dec 14 94.
;;; Usage:
;;;
;;;  basepop11 %noinit update_pop ____Sdir ____rdir _____rhost ________username ________password
;;;
;;; where   ____Sdir	 = S. master directory for Poplog system (full path)
;;; 		____rdir	 = remote usepop (without brackets for VMS e.g. pop.S_vaxvms)
;;;			_____rhost	 = hostname of remote system
;;;			________username = user to log in as
;;;			________password = password
;;;
;;; Transfers everything with a date >= the file
;;;
;;; 		____Sdir/.UPDATED:_____rhost
;;;
;;; or everything if that doesn't exist. Creates that file under another name
;;; before starting, and replaces it at the end.
;;;
;;; If ________username = -show (any ________password), just lists ftp commands generated.

lconstant
	statvec = initv(2),
;

lvars
	since_time	= false,
	ftp_pid		= false,
	procedure ftp_charout,
	put_count	= 0,
	ftp_comm	= false,
	ftp_args	= false,
	ftp_open_comms = [],
	show_commands,
	is_vms
;

define lconstant ftp_printf();
	dlocal cucharout = ftp_charout;
	printf()
enddefine;

define lconstant do_dir(dir, rdir, create_list);
	lvars dir, rdir, create_list, files, dirs, f, d;
	dlocal current_directory = dir;

	define lconstant create_dirs(create_list);
		lvars create_list, d = hd(create_list);
		returnunless(d);
		create_dirs(tl(create_list));
		ftp_printf(d, is_vms and 'mkdir %p]\n' or 'mkdir %p\n');
		false -> hd(create_list)
	enddefine;

	sys_matchin_dir('.', false, 2:110) -> (files, dirs);
	fast_for f in nc_listsort(files, alphabefore) do
		if not(since_time)
		or sys_file_stat(f, statvec) and statvec(2) >= since_time then
			create_dirs(create_list);
			unless show_commands then
				;;; SHELL is redefined as /bin/echo, so this
				;;; prints '-c ________filename' (synchronises it with ftp output)
				ftp_printf(f, current_directory, '!%p%p\n')
			endunless;
			ftp_printf(f, rdir, f, current_directory,
						is_vms and 'put %p%p %p]%p\n' or 'put %p%p %p/%p\n');
			if is_vms and (put_count+1 ->> put_count) == 200 then
				ftp_charout('close\n');
				applist(ftp_open_comms, ftp_charout);
				0 -> put_count
			endif
		endif
	endfor;

	fast_for d in nc_listsort(dirs, alphabefore) do
		do_dir(d, dup(sprintf(d, rdir, is_vms and '%p.%p' or '%p/%p'))
						:: create_list)
	endfor
enddefine;


lvars (Sdir, rdir, rhost, username, password) = dl(poparglist);
lvars timestamp, next_timestamp;

if (username = '-show' ->> show_commands) then
	'/bin/cat' -> ftp_comm;
	[^ftp_comm] -> ftp_args;
else
	'/bin/ftp' -> ftp_comm;
	[^ftp_comm '-n'] -> ftp_args;
	'/bin/echo' -> systranslate('SHELL');
endif;
[%	sprintf(rhost, 'open %p\n'),
	sprintf(password, username, 'user %p %p\n')
%] -> ftp_open_comms;

lvars (dout, din) = syspipe(false);
if sys_vfork(true) ->> ftp_pid then
	sysclose(din);
	discout(dout) -> ftp_charout;
	applist(ftp_open_comms, ftp_charout)
else
	sysclose(dout);
	din -> popdevin;
	sysexecute(ftp_comm, ftp_args, false)
endif;

sys_fname_path(Sdir) -> current_directory;
sys_fname_name(Sdir) -> Sdir;
isendstring('vms', Sdir) -> is_vms;
sprintf(rhost, Sdir, '%p/.UPDATED:%p') -> timestamp;

unless show_commands then
	sprintf(timestamp, '%p+') -> next_timestamp;
	1 -> pop_file_versions;
	sysclose(syscreate(next_timestamp, 1, false));
endunless;

sys_file_stat(timestamp, statvec) and statvec(2) -> since_time;

do_dir(Sdir, sprintf(rdir, is_vms and '[%p.pop' or '%p/pop'), [^false]);

unless show_commands then
	ftp_printf('!**** FINISHED ****\n')
endunless;

ftp_charout(termin);
lvars (, status) = sys_wait(ftp_pid);

unless status /== 0 or show_commands then
	3 -> pop_file_versions;
	sys_file_move(next_timestamp, timestamp);
endunless;
