/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_editor.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 25th May 1993
;;; File: go_editor.p
;;; Author: B L Rabau

compile_mode :pop11 +strict;

uses go_located;

/* Extra dependencies further in this file:
uses go_xdrag;
uses go_pane;
 */

;;; INTRO: --------------------------------------------------------------
;;; INTRO: EDITABLE OBJECTS: ARE USED TO EDIT OTHER OBJECTS:
;;; INTRO:
;;; INTRO: WARNING:
;;; INTRO:         THIS MIXIN NEEDS TO BE USED WITH GO_SCREEN_OBJECTS
;;; INTRO: --------------------------------------------------------------

define :mixin go_editor;
	slot go_edited_object        == false;
;;; REF: Handle to object which is edited by this editor if any (else false)
	slot stored_go_get_absolute  == go_position_of_centre;
;;; REF: Procedure to get position of editor in World Coordinates
	slot stored_go_move_absolute == updater(go_position_of_centre);
;;; REF: Procedure to set position of editor in World Coordinates
enddefine;


;;;--------------------------------------------------------------

define :method go_move_absolute( obj :go_editor );
lvars obj;
;;; REF: go_move_absolute( EDITOR ) -> PROCEDURE;
	stored_go_move_absolute( obj );
enddefine;

define :method updaterof go_move_absolute( proc, obj :go_editor );
lvars proc, obj;
;;; REF: PROCEDURE -> go_move_absolute( EDITOR );
;;; REF: Procedure attached to the editor which will be executed whenever the
;;; REF: editor moves.
;;; REF: EDITOR is an instance of the go_editor class (REF * GO_EDITOR).
	proc -> stored_go_get_absolute( obj );
	updater(proc) -> stored_go_move_absolute( obj );
enddefine;

;;;--------------------------------------------------------------
;;; DRAW

define :method go_internal_redraw( obj :go_editor );
lvars obj;
;;; REF: go_internal_redraw( EDITOR );
;;; REF: Redraws both the edited object and the editor itself (on top), but
;;; REF: only the objects on top of the edited object are redrawn so the
;;; REF: objects underneath can be wrong.
;;; REF: EDITOR is an instance of the go_editor class (REF * GO_EDITOR).
	if ( obj.go_edited_object ) then go_internal_redraw( obj.go_edited_object );
	endif;
	;;; this should find the other go_internal_redraw() methods
	call_next_method( obj );
enddefine;

define :method go_redraw( obj :go_editor );
lvars obj;
;;; REF: go_internal_redraw( EDITOR );
;;; REF: Redraws the area of the edited object and the editor itself (on top).
;;; REF: EDITOR is an instance of the go_editor class (REF * GO_EDITOR).
	if ( obj.go_edited_object ) then go_redraw( obj.go_edited_object ); endif;
	;;; this should find the other go_redraw() methods
	call_next_method( obj );
enddefine;

define :method go_clear( obj :go_editor );
lvars obj;
;;; REF: go_internal_redraw( EDITOR );
;;; REF: Clears both of the edited object and the editor itself.
;;; REF: EDITOR is an instance of the go_editor class (REF * GO_EDITOR).
lvars pane;
	;;; the editor needs to be removed otherwise go_clear() would redraw it!!!
	if ( obj.go_edited_object ) then go_clear( obj.go_edited_object ); endif;
enddefine;


;;;--------------------------------------------------------------
;;; DESTROY:
define :method go_destroy_object( obj :go_editor );
lvars obj;
lvars edited_obj = obj.go_edited_object;
	call_next_method( obj );
	go_redraw( edited_obj );
enddefine;


;;;----------------------------------------------------------------
;;; MULTI-METHODS USING GO_PANE
;;; uses go_pane;
;;; TO AVOID CIRCULAR DEPENDENCIES :go_pane IS NOT USED IN THIS FILE
;;; THIS DOES NOT MATTER SINCE THE FIRST CALL IS call_next_method SO
;;; THE TYPE-CHECKING WILL HAPPEN IMMEDIATELY ANYWAY!
;;;----------------------------------------------------------------

;;; The go_safe_region (redrawn go_area) is that of the edited object.
;;; This means that the reference go_point and the attachment go_point
;;; need to lay inside the object being eedited!

define :method go_safe_region( pane, obj :go_editor ) -> (x, y, w, h);
lvars pane, obj, x, y, w, h;
;;; REF: go_bounding_box( PANE, EDITOR ) -> (X, Y, W, H );
;;; REF: The safe region in screen coordinates of an editor comprises both the
;;; REF: safe region of the edited object and sufficient space for the editor
;;; REF: to be on its borders (see also REF * GO_LOCATED).
;;; REF: WARNING! go_bounding_box methods (including width and height) do NOT
;;; REF:          include this extra space which allows editors to have centres
;;; REF:          which are distinct from those from their edited  object.
;;; REF: PANE is an instance of the go_pane class (REF * GO_PANE).
;;; REF: EDITOR is an instance of the go_editor class (REF * GO_EDITOR).
;;; REF: X and Y are the screen coordinates of the occupied area of the object.
;;; REF: W and H are the screen dimensions of the occupied area of the object.
lvars wedit, hedit, xobj, yobj, wobj, hobj;
	call_next_method( pane, obj ) -> (x, y, w, h);
	if (h < 0) then -h -> h; endif;
	if obj.go_edited_object then
		go_safe_region(pane, obj.go_edited_object) -> (xobj, yobj, wobj, hobj);
		if (wobj < 0) then -wobj -> wobj; xobj - wobj -> xobj; endif;
		if (hobj < 0) then -hobj -> hobj; yobj - hobj -> yobj; endif;
		xobj - w -> x;
		yobj - h -> y;
		wobj + w*2 -> w;
		hobj + h*2 -> h;
	else
		;;; 'Warning: editor not attached to an object' =>
		;;; obj =>
	endif;
enddefine;


;;;----------------------------------------------------------------
;;; METHODS USING GO_SCREEN_OBJECT:
;;; uses go_screen_object;
vars procedure go_check_drag_limits;   ;;; DEFINED IN GO_SCREEN_OBJECT
vars go_drag_outline;                  ;;; DEFINED IN GO_SCREEN_OBJECT
vars procedure go_draw_bounding_box;   ;;; DEFINED IN GO_SCREEN_OBJECT
;;;----------------------------------------------------------------

;;;----------------------------------------------------------------
;;; METHODS USING DRAGGING: DEFAULT X-WINDOWS:
;;; uses go_xdrag;
vars procedure go_drag;                ;;; DEFINED IN GO_XDRAG
vars procedure inDrag;                 ;;; DEFINED IN GO_XDRAG
vars procedure lastCoords;             ;;; DEFINED IN GO_XDRAG
vars procedure dragWidth;              ;;; DEFINED IN GO_XDRAG
vars procedure dragHeight;             ;;; DEFINED IN GO_XDRAG
vars procedure startXOffset;           ;;; DEFINED IN GO_XDRAG
vars procedure startYOffset;           ;;; DEFINED IN GO_XDRAG
;;;----------------------------------------------------------------

;;;--------------------------------------------------------------
;;; DIRECT MANIPULATION

define :method go_draw_drag(client, obj :go_editor);
lvars client, obj;
;;; REF: go_draw_drag( DRAG_DATA, EDITOR );
;;; REF: Drags the edit point and updates the object it is editing.
;;; REF: (see REF * GO_SCREEN_OBJECT/go_draw_drag).
;;; REF: DRAG_DATA is a structure with drag data (REF * GO_XDRAG).
;;; REF: EDITOR is an instance of the go_editor class (REF * GO_EDITOR).
lvars x, y, w, h, xmin, ymin, xmax, ymax;
lvars dragged_obj = (obj.go_edited_object or obj);
	explode(client.lastCoords) -> (x, y);
	x + client.startXOffset -> x;
	y + client.startYOffset -> y;
	go_check_drag_limits( x, y, obj ) -> (obj.go_xcentre, obj.go_ycentre);
	if (client.inDrag) then
		unless (go_drag_outline) then
			go_redraw( obj );
		endunless;
		go_draw_bounding_box( dragged_obj );
	else
		go_redraw( obj );
	endif;
	go_bounding_box( dragged_obj )  -> (,,client.dragWidth, client.dragHeight);
	{% dragged_obj.go_xcentre, dragged_obj.go_ycentre %} -> client.lastCoords;
enddefine;


;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_editable = true;


/* --- Revision History --------------------------------------------
 * BR 25/05/93
 *     Added comments to the file.
 * BR 30/04/93
 *     Moved go_edit_point class into separate file
 * BR,AR 14/04/93
 *     Removed go_prut() and replaced by a new MIXIN go_short_print
 *     which overwrites the standard print_object() method of OC to
 *     avoid printing out objects which refer to themselves. This is
 *     only necessarry until OC has a objectclass_print_limit vars.
 * BR 08/04/93
 *     Removed direct call to XpwDrawLine[s]() by go_draw_line[s]();
 *     Removed direct call to XpwDrawSegments() by go_draw_line_segments();
 *     Removed direct call to XpwDrawArcs() by go_draw_arcs();
 *     Removed direct call to XpwFillArcs() by go_draw_filled_arcs();
 *     Removed direct call to XpwDrawRectangle() by go_draw_rectangle();
 *     Removed direct call to XpwClearArea() by go_clear_rectangle()
 *     Removed direct call to XpwFillPolygon() by go_draw_filled_polygon()
 * BR 06/04/93
 *     Renamed the mixin go_editable to go_editor
 * BR 30/03/93
 *     Changed go_window_pane class into go_pane class.
 * BR 07/03/93
 *     Added a go_show() method with the pane as second argument.
 * BR 10/12/92
 *     Changed check_pane_limits into go_check_drag_limits.
 * BR 26/11/92
 *     Global Name changes and code cleanup
 * BR 16/11/92
 *     Created this file from code in go_point.p...
 */
;;; eof
