/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_fillable.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 13th July 1993
;;; File: go_fillable.p
;;; Author: B L Rabau

compile_mode :pop11 +strict;

uses go_screen_object;
uses go_xdrag;

;;; --------------------------------------------------------------------

;;; INTRO: The MIXIN go_fillable allows a go_screen_object to become filled.
;;; INTRO: See REF * GO_SCREEN_OBJECT and go_bgcolour in REF * GO_COLOURABLE.
;;; INTRO: A special global variable go_drag_filled allows optimised dragging.
;;; INTRO: See REF * GO_VARS/go_drag_filled.

define :mixin go_fillable;
	slot stored_go_filled   = false;
;;; REF: Boolean: whether the object is filled or not, this relates to the
;;; REF: part of the object drawn in background colour. See also:
;;; REF: REF * GO_COLOURABLE/go_bgcolour and REF * GO_XDRAW/go_bgdraw.
enddefine;

vars  go_drag_filled = true;  ;;; REF: Global var: Draw filling if fillable.
;;; REF: Global var: go_drag_filled allows optimised dragging of filled
;;; REF: Global var: screen objects, by only drawing the foreground and not
;;; REF: Global var: the background. See REF * GO_FILLABLE/go_draw_drag.

lvars go_prevent_filling = false;      ;;; Local var for optimised dragging

;;; --------------------------------------------------------------------
;;; INFLUENCING THE FILLING OF OBJECTS

define :method go_filled( obj :go_fillable );
lvars obj;
;;; REF: go_filled( FILLABLE ) -> BOOLEAN;
;;; REF: Returns whether or not the fillable screen object is filled.
;;; REF: FILLABLE is an go_fillable instance (see REF * GO_FILLABLE);
	if ( go_prevent_filling ) then false; else obj.stored_go_filled; endif;
enddefine;

define :method updaterof go_filled( new_f, obj :go_fillable );
lvars new_f, obj;
;;; REF: BOOLEAN -> go_filled( FILLABLE );
;;; REF: Sets whether or not the fillable screen object is filled.
;;; REF: FILLABLE is an go_fillable instance (see REF * GO_FILLABLE);
	new_f -> obj.stored_go_filled;
	go_update( obj );
	if (new_f) then
		go_internal_redraw(obj);        ;;; no need to do the redraw stuff below
	else
		go_clear(obj);
		go_redraw(obj);                 ;;; redraw stuff below! (transparent)
	endif;
enddefine;

;;; --------------------------------------------------------------------
;;; ARRANGE = DRAG AND DROP INTERFACE
;;;      uses the fast go_drag mechanism from LIB * RC_DRAG
;;;      needs go_motionhint to be true
;;;

define :method go_draw_drag(client, drag_obj :go_fillable);
lvars client, drag_obj;
;;; REF: go_draw_drag( CLIENT_DATA, FILLABLE );
;;; REF: Warning: This REDEFINES go_draw_drag from in LIB * GO_SCREEN_OBJECT.
;;; REF: It offers an additional performance improvement with the global
;;; REF: variable go_drag_filled:
;;; REF:     1. If go_drag_filled is false then objects will be dragged over the
;;; REF:        screen without being filled and on top of every other object.
;;; REF:     2. If go_drag_filled is true, a filled object will be filled and
;;; REF:        shown in its right screen depth even during dragging.
;;; REF: This method is called from the go_drag method and should never be
;;; REF: called directly.
;;; REF: CLIENT_DATA is a structure containing information for dragging.
;;; REF: FILLABLE is an go_fillable instance (see REF * GO_FILLABLE);
lvars x, y, xmin, ymin, xmax, ymax;
	define lconstant top_draw( obj, pane );
	lvars obj, pane;
		go_draw( pane, obj );
	enddefine;

	explode(client.lastCoords) -> (x, y);
	go_check_drag_limits(x, y, drag_obj) -> (x, y);
	x -> drag_obj.go_xcentre;
	y -> drag_obj.go_ycentre;
	if (client.inDrag) then
		unless (go_drag_outline) then
			if (go_drag_filled) then
				go_internal_redraw( drag_obj );
			else
				true -> go_prevent_filling;       ;;; Should be hidden var
				go_applist( top_draw, drag_obj ); ;;; draws on top
				false -> go_prevent_filling;      ;;; Should be hidden var
			endif;
		endunless;
		go_draw_bounding_box(drag_obj);
	else
		go_redraw( drag_obj );
	endif;
	{% x, y %} -> client.lastCoords;
enddefine;

;;; --------------------------------------------------------------------
;;; Variable for "uses"
vars go_fillable = true;

/* --- Revision History --------------------------------------------
 * BR 13/07/93
 *     Adapted lastCoords field of drag context to reflext centre position!
 * BR 08/05/93
 *     Changed go_check_drag_limits because it no longer sets the go_[x/y]loc.
 * BR 05/05/93
 *     Added comments.
 * BR 10/12/92
 *     Changed check_pane_limits into go_check_drag_limits.
 * BR 26/11/92
 *     Global Name changes and code cleanup
 */
;;; eof
