/* --- Copyright University of Sussex 1993. All rights reserved. ----------
 > File:            C.all/lib/proto/go/lib/go_sensitive.p
 > Purpose:         GO file
 > Author:          Ben Rabau, 1992-1993
 > Documentation:   HELP GO_CLASSES
 > Related Files:
 */
													   ;;; 04th May 1992
;;; File: go_sensitive.p
;;; Authors: J L Cunningham, B Rabau

compile_mode :pop11 +strict;

;;; This file defines procedures used by the go_mouse_sensitive and the
;;; go_key_sensitive mixins in the GO library. They provide compilation
;;; and decompilation procedures for attaching actions to GO objects.
;;; See LIB * GO_MOUSE_SENSITIVE and LIB * GO_KEY_SENSITIVE

;;;------------------------------------------------------
;;; Definitions which where previously defined in sketch_basics.p

;;; Compile a new action before attaching to object:
define go_compile_action(str);
lvars str, proc;
;;; REF: go_compile_action( STRING ) -> PROCEDURE;
;;; REF: Compile the string and return the pop11 procedure represented by it.
	if str = 'identfn();' then
		identfn;        ;;; USED TO BE no_action; IS IT WRONG ????
	else
		popval([procedure;]<>
			pdtolist(incharitem(stringin(str)))<>
			[endprocedure;]) -> proc;
		str -> pdprops(proc);
		proc
	endif;
enddefine;

;;; Retrieve original action description attached to object:
define go_action_string(proc);
lvars proc;
;;; REF: go_compile_action( PROCEDURE ) -> STRING;
;;; REF: Return the string of which the pop11 procedure was compiled.
	pdprops(proc) or
	pdprops(identfn);    ;;; suppress action if pdprops are false
						 ;;; USED TO BE pdprops(no_action); IS IT WRONG ????
enddefine;

;;;----------------------------------------------------------------
;;; Variable for "uses"
vars go_sensitive = true;


/* --- Revision History --------------------------------------------
 * BR 04/05/93
 *     Split file go_sensitive.p into three parts:
 *         - go_sensitive.p       Common procedures for compilation aid
 *         - go_key_sensitive.p   The mixin for adding keyboard sensitivity
 *         - go_mouse_sensitive.p The mixin for adding mouse sensitivity
 *     Added go_ prefix to: compile_action() & action_string();
 * AS 27/04/93
 *     Added comments.
 * AS 25/04/93
 *     Corrected go_key_sensitive to be a mixin (rather than a class)
 * BR 29/01/93
 *     Adapted for completely new strategy in go_action.p
 * BR 23/12/92
 *     Made the go_keyboard() method immediate (otherwise the actions need to
 *     be made uninterruptable!!!)
 * BR 26/11/92
 *     Global Name changes and code cleanup
 * BR 23/11/92
 *     Made a go_key_sensitive class & renamed sensitive classs go_mouse_sensitive
 * BR 05/10/92
 *     Moved non_action(), go_compile_action() and go_action_string() from
 *     LIB sketch_basics.p in this file (see MajorChanges).
 *     Moved handle_mouse_down() from class UI_object to this sensitive class.
 *     removed go_class_attributes() (see SKETCH MajorChanges)
 * BR 09/09/92
 *     Corrected select_action_ng into go_select_action_string in go_class_attributes()
 * BR 24/07/92
 *     Made include file; sensitive was originally defined in sketch_basics.p
 */
;;; eof
